/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph;

import org.simantics.objmap.graph.impl.Mapping;
import org.simantics.objmap.graph.schema.IMappingSchema;
/**
 * Static utility methods for mappings. 
 * @author Hannu Niemist
 */
public class Mappings {
	private Mappings() {}
	
	/**
	 * Creates a new mapping based on the given mapping schema. 
	 * The created mapping is not thread-safe and will not
	 * listen database changes automatically.
	 */
	public static <Domain,Range> IMapping<Domain,Range> createWithoutListening(IMappingSchema<Domain,Range> schema) {
		return new Mapping<Domain,Range>(schema, false);
	}
	
	/**
     * Creates a new mapping based on the given mapping schema. 
     * The created mapping is not thread-safe. It listens database
     * changes automatically.
     */
	public static <Domain,Range> IMapping<Domain,Range> createWithListening(IMappingSchema<Domain,Range> schema) {
        return new Mapping<Domain,Range>(schema, true);
    }
	
	
}
