/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.forward;

import org.simantics.db.ReadGraph;
import org.simantics.objmap.exceptions.MappingException;

public interface IForwardMappingRule<Domain, Range> {
	/**
	 * Check whether a range element needs to be updated due to a change in the range element, without modifying the range element.
	 */
	boolean checkChanges(ReadGraph graph, IForwardMapping<Domain, Range> mapping, Domain domainElement, Range rangeElement) throws MappingException;
	
	/**
	 * Modifies the range element so that it corresponds to the domain element.
	 * @param g read transaction
	 * @param map unidirectional view of the current mapping
	 * @param domainElement the domain element that corresponds to the range element
	 * @param rangeElement the range element that is updated
	 * @return true if the rule made some modifications
	 * @throws MappingException
	 */
	boolean updateRange(ReadGraph graph, IForwardMapping<Domain, Range> mapping, Domain domainElement, Range rangeElement) throws MappingException;
	void createRange(ReadGraph graph, IForwardMapping<Domain, Range> mapping, Domain domainElement, Range rangeElement) throws MappingException;
}
