/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem.internal;

/**
 * @author Tuukka Lehtonen
 */
public enum OS {
    APPLE, LINUX, SUN, WINDOWS, UNKNOWN;

    public static OS calculate() {
        String osName = System.getProperty("os.name");
        assert osName != null;
        osName = osName.toLowerCase();
        if (osName.startsWith("mac os x"))
            return APPLE;
        if (osName.startsWith("windows"))
            return WINDOWS;
        if (osName.startsWith("linux"))
            return LINUX;
        if (osName.startsWith("sun"))
            return SUN;
        return UNKNOWN;
    }
}
