/*******************************************************************************
 * Copyright (c) 2016, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem.internal;

import org.simantics.nativemem.ProcessMemoryInfo;

/**
 * @author Tuukka Lehtonen
 */
public class CMemoryInfo implements ProcessMemoryInfo {

    public long currentRSS;
    public long peakRSS;

    @Override
    public String toString() {
        return "CMemoryInfo [Current RSS="
                + currentRSS + ", Peak RSS="
                + peakRSS + "]";
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RSS ").append(Util.toMb(currentRSS))
        .append("M / ").append(Util.toMb(peakRSS))
        .append("M");
        return sb.toString();
    }

    @Override
    public String headerRow() {
        return "RSS [MB]\tPeak RSS [MB]";
    }

    @Override
    public String dataRow() {
        return Util.toMb(currentRSS) + "\t" + Util.toMb(peakRSS);
    }

    public static void main(String[] args) {
        System.out.println(new CMemoryInfo().toHumanReadableString());
        System.out.println(new CMemoryInfo().headerRow());
        System.out.println(new CMemoryInfo().dataRow());
    }

}