/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals.rules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;
import org.simantics.modeling.typicals.rules.Properties;

public enum ProfileMonitorRule implements ITypicalSynchronizationRule
{
    INSTANCE;


    public static ProfileMonitorRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        boolean changed = false;
        boolean result = changed |= Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Element_upProfileMonitors);
        if (result) {
            info.messageLog.add("\t\t\tgrow profile monitors upward => " + graph.getPossibleRelatedValue(instance, DIA.Element_upProfileMonitors));
        }
        changed |= result;
        result = Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Element_hideProfileMonitors);
        if (result) {
            info.messageLog.add("\t\t\thide profile monitors => " + graph.getPossibleRelatedValue(instance, DIA.Element_hideProfileMonitors));
        }
        changed |= result;
        result = Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Element_profileMonitorOffset);
        if (result) {
            info.messageLog.add("\t\t\tprofile monitor offset => " + graph.getPossibleRelatedValue(instance, DIA.Element_profileMonitorOffset));
        }
        changed |= result;
        result = Properties.synchronizeEnumerationPropertyValue(graph, template, instance, DIA.Element_profileMonitorSpacing);
        if (result) {
            info.messageLog.add("\t\t\tprofile monitor spacing => " + graph.getPossibleRelatedValue(instance, DIA.Element_profileMonitorSpacing));
        }
        return changed |= result;
    }
}

