/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.history.HistoryException;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.modeling.subscription.ModelHistoryCollector;
import org.simantics.modeling.subscription.SubscriptionCollectionResult;

class VariableSetListener
extends ListenerAdapter<SubscriptionCollectionResult> {
    private final ModelHistoryCollector modelHistoryCollector;
    boolean disposed;

    VariableSetListener(ModelHistoryCollector modelHistoryCollector) {
        this.modelHistoryCollector = modelHistoryCollector;
    }

    public void execute(final SubscriptionCollectionResult result) {
        Job job = new Job("Reloading history subscriptions"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (VariableSetListener.this.modelHistoryCollector.itemCollector.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    if (!result.getStatus().isOK() && VariableSetListener.this.modelHistoryCollector.logger != null) {
                        VariableSetListener.this.modelHistoryCollector.logger.log((IStatus)result.getStatus());
                    }
                    final IStatus[] status = new IStatus[1];
                    Runnable loader = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                List<SubscriptionItem> sampledItems = ModelHistoryCollector.sampledSubscriptionItems(result.getSubscriptions());
                                (this).VariableSetListener.this.modelHistoryCollector.itemCollector.load(sampledItems);
                            }
                            catch (HistoryException e) {
                                status[0] = new Status(4, "org.simantics.modeling", e.getLocalizedMessage(), (Throwable)e);
                                if ((this).VariableSetListener.this.modelHistoryCollector.logger != null) {
                                    (this).VariableSetListener.this.modelHistoryCollector.logger.log(status[0]);
                                }
                            }
                            catch (DatabaseException e) {
                                (this).VariableSetListener.this.modelHistoryCollector.log.log(Level.WARNING, "Unexpected failure in history variable collection request.", e);
                                status[0] = new Status(4, "org.simantics.modeling", e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    };
                    if (VariableSetListener.this.modelHistoryCollector.loadThread != null) {
                        VariableSetListener.this.modelHistoryCollector.loadThread.syncExec(loader);
                    } else {
                        loader.run();
                    }
                    if (status[0] == null && VariableSetListener.this.modelHistoryCollector.loadCallback != null) {
                        VariableSetListener.this.modelHistoryCollector.loadCallback.run();
                    }
                    IStatus iStatus = status[0] != null ? status[0] : Status.OK_STATUS;
                    return iStatus;
                }
                catch (RejectedExecutionException e) {
                    Status status = new Status(1, "org.simantics.modeling", e.getLocalizedMessage(), (Throwable)e);
                    return status;
                }
                finally {
                    VariableSetListener.this.modelHistoryCollector.initMutex.release();
                }
            }
        };
        job.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)this.modelHistoryCollector));
        job.setUser(false);
        job.schedule();
    }

    public void dispose() {
        this.disposed = true;
    }

    public void exception(Throwable t) {
        this.modelHistoryCollector.initMutex.release();
        this.modelHistoryCollector.log.log(Level.WARNING, "Unexpected failure in history variable collection request.", t);
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

