/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.jface.viewers.IFilter;
import org.simantics.db.Resource;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.requests.Nodes;
import org.simantics.scl.runtime.function.Function1;

public class CollectionResult {
    public static final IFilter DIAGRAM_RESOURCE_FILTER = o -> Nodes.DIAGRAM_RESOURCE_PREDICATE.test((Node)o);
    public static final IFilter DIAGRAM_RESOURCE_AND_RVI_FILTER = o -> Nodes.DIAGRAM_RESOURCE_AND_RVI_PREDICATE.test((Node)o);
    public final Set<Node> roots;
    private final Set<Node> diagramSet;
    public final List<Node> diagramList;
    public final Map<Resource, Node> diagrams;

    public CollectionResult() {
        this.roots = new ConcurrentSkipListSet<Node>();
        this.diagramSet = new ConcurrentSkipListSet<Node>();
        this.diagramList = new Vector<Node>();
        this.diagrams = new ConcurrentHashMap<Resource, Node>();
    }

    private CollectionResult(Set<Node> roots, Set<Node> diagramSet, List<Node> diagramList, Map<Resource, Node> diagrams) {
        this.roots = roots;
        this.diagramSet = diagramSet;
        this.diagramList = diagramList;
        this.diagrams = diagrams;
    }

    public CollectionResult withRoots(Set<Node> roots) {
        return new CollectionResult(roots, this.diagramSet, this.diagramList, this.diagrams);
    }

    public void addDiagram(Resource r, Node n) {
        this.diagramList.add(n);
        this.diagrams.put(r, n);
        this.diagramSet.add(n);
    }

    public Collection<Node> breadthFirstFlatten() {
        return this.breadthFirstFlatten(null);
    }

    public Collection<Node> breadthFirstFlatten(IFilter filter) {
        return Nodes.breadthFirstFlatten(new DiagramFilter(filter), this.roots);
    }

    public Collection<Node> depthFirstFlatten() {
        return this.depthFirstFlatten(null, null);
    }

    public Collection<Node> depthFirstFlatten(IFilter filter, Comparator<? super Node> comparator) {
        return Nodes.depthFirstFlatten(new DiagramFilter(filter), this.roots, comparator);
    }

    public boolean walkTree(Function1<Node, Boolean> f) {
        return Nodes.walkTree(f, this.roots);
    }

    public class DiagramFilter
    implements IFilter {
        private final IFilter proxy;

        public DiagramFilter(IFilter proxy) {
            this.proxy = proxy;
        }

        public boolean select(Object node) {
            return CollectionResult.this.diagramSet.contains(node) && (this.proxy == null || this.proxy.select(node));
        }
    }
}

