/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.SimanticsPlatform;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.external.EclipsePreferencePrimitiveRead;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Write;
import org.simantics.db.service.DebugSupport;
import org.simantics.db.service.ServiceActivityMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCL {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCL.class);

    public static void killPlatformWrite(WriteGraph graph) throws DatabaseException {
    }

    public static void killPlatformRead(ReadGraph graph) throws DatabaseException {
    }

    public static void killPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.shutdown(null);
    }

    public static void shutdownPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.shutdown(null);
    }

    public static void reconnectPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.reconnect(Simantics.getDefaultDatabaseDriver());
    }

    public static void synchronizeOntologies() throws Exception {
        SimanticsPlatform.INSTANCE.synchronizeOntologies((IProgressMonitor)new NullProgressMonitor(), SimanticsPlatform.OntologyRecoveryPolicy.Merge, true);
        ((DebugSupport)Simantics.getSession().getService(DebugSupport.class)).query(Simantics.getSession(), "exec QueryControl.flush");
    }

    public static void sync() throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
            }

            public String toString() {
                return "Utils sync";
            }
        });
    }

    public static void syncGraph() throws Exception {
        Job[] jobs;
        try {
            ((ServiceActivityMonitor)Simantics.getSession().getService(ServiceActivityMonitor.class)).waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new DatabaseException((Throwable)e);
        }
        IJobManager job = Job.getJobManager();
        Job[] jobArray = jobs = job.find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job j = jobArray[n2];
            if (j instanceof DatabaseJob) {
                j.join();
            }
            ++n2;
        }
        SCL.sync();
    }

    public static boolean deleteMBNode(List<Resource> resources) throws DatabaseException {
        boolean value = false;
        try {
            value = RemoverUtil.tryCollectionRemover(resources);
        }
        catch (DatabaseException databaseException) {
            return value;
        }
        return value;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Sleep was interrupted.", (Throwable)e);
        }
    }

    public static boolean hasSomethingToPaste(ReadGraph graph, Resource resource) throws DatabaseException {
        SimanticsClipboard clipboard = Simantics.getClipboard();
        return !clipboard.getContents().isEmpty();
    }

    public static boolean canDelete(ReadGraph graph, Resource resource) throws DatabaseException {
        return RemoverUtil.canRemove((ReadGraph)graph, (Resource)resource);
    }

    public static boolean canRename(ReadGraph graph, Resource resource) throws DatabaseException {
        return true;
    }

    public static String currentDate(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    public static File workspaceDirectory() {
        return new File(Platform.getInstanceLocation().getURL().getFile());
    }

    public static String queryPreference(ReadGraph graph, String pluginId, String preferenceKey) throws DatabaseException {
        String result = (String)graph.syncRequest((ExternalRead)new EclipsePreferencePrimitiveRead(pluginId, preferenceKey));
        if (result == null) {
            return "";
        }
        return result;
    }
}

