/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.simantics.db.layer0.util.PrimitiveValueParser;
import org.simantics.utils.datastructures.slice.ValueRange;

public class ValueUtil {
    public static String arrayValueToString(Object object, ValueRange range) {
        if (object == null) {
            return "";
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("object is not an array: " + clazz.getCanonicalName());
        }
        int length = Array.getLength(object);
        assert (range != null);
        if (range.start() >= length || range.end() > length) {
            throw new ArrayIndexOutOfBoundsException(range + " out of array bounds [0," + length + "]");
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        int i = range.start();
        while (i < range.end()) {
            if (!first) {
                b.append(",");
            }
            first = false;
            b.append(Array.get(object, i));
            ++i;
        }
        return b.toString();
    }

    public static String valueToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String[]) {
            Object[] value = (String[])object;
            if (value.length == 1) {
                return value[0];
            }
            return Arrays.toString(value);
        }
        if (object instanceof int[]) {
            int[] value = (int[])object;
            if (value.length == 1) {
                return String.valueOf(value[0]);
            }
            StringBuffer buffer = new StringBuffer();
            if (value.length > 0) {
                buffer.append(value[0]);
                int i = 1;
                while (i < value.length) {
                    buffer.append(", ");
                    buffer.append(value[i]);
                    ++i;
                }
            }
            return buffer.toString();
        }
        if (object instanceof boolean[]) {
            boolean[] value = (boolean[])object;
            if (value.length == 1) {
                return String.valueOf(value[0]);
            }
            return Arrays.toString(value);
        }
        if (object instanceof double[]) {
            double[] value = (double[])object;
            if (value.length == 1) {
                return String.valueOf(value[0]);
            }
            StringBuffer buffer = new StringBuffer();
            if (value.length > 0) {
                buffer.append(value[0]);
                int i = 1;
                while (i < value.length) {
                    buffer.append(", ");
                    buffer.append(value[i]);
                    ++i;
                }
            }
            return buffer.toString();
        }
        if (object instanceof float[]) {
            float[] value = (float[])object;
            if (value.length == 1) {
                return String.valueOf(value[0]);
            }
            StringBuffer buffer = new StringBuffer();
            if (value.length > 0) {
                buffer.append(value[0]);
                int i = 1;
                while (i < value.length) {
                    buffer.append(", ");
                    buffer.append(value[i]);
                    ++i;
                }
            }
            return buffer.toString();
        }
        if (object instanceof long[]) {
            long[] value = (long[])object;
            if (value.length == 1) {
                return String.valueOf(value[0]);
            }
            return Arrays.toString(value);
        }
        if (object instanceof byte[]) {
            byte[] value = (byte[])object;
            if (value.length == 1) {
                return String.valueOf(value[0]);
            }
            return Arrays.toString(value);
        }
        return object.toString();
    }

    public static Object parseLabelToObject(Class<?> valueClass, String label) {
        if (valueClass == boolean[].class) {
            return PrimitiveValueParser.parseBooleanArray((String)label);
        }
        if (valueClass == int[].class) {
            return PrimitiveValueParser.parseIntArray((String)label);
        }
        if (valueClass == long[].class) {
            return PrimitiveValueParser.parseLongArray((String)label);
        }
        if (valueClass == float[].class) {
            return PrimitiveValueParser.parseFloatArray((String)label);
        }
        if (valueClass == double[].class) {
            return PrimitiveValueParser.parseDoubleArray((String)label);
        }
        if (valueClass == String[].class) {
            return new String[]{label};
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return PrimitiveValueParser.parseBoolean((String)label);
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return PrimitiveValueParser.parseInt((String)label);
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return PrimitiveValueParser.parseLong((String)label);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(PrimitiveValueParser.parseFloat((String)label));
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return PrimitiveValueParser.parseDouble((String)label);
        }
        if (valueClass == Byte.class || valueClass == Byte.class) {
            return PrimitiveValueParser.parseByte((String)label);
        }
        if (valueClass == String.class) {
            return label;
        }
        return null;
    }
}

