/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.ui.workbench.preferences.NumberFieldEditor;

public class SubscriptionPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private NumberFieldEditor fSubscriptionDeadbandEditor = null;
    private NumberFieldEditor fSubscriptionIntervalEditor = null;
    private NumberFieldEditor fSubscriptionGainEditor = null;
    private NumberFieldEditor fSubscriptionBiasEditor = null;
    private BooleanFieldEditor fSubscriptionShowValues = null;

    public SubscriptionPreferencePage() {
        super(1);
        ScopedPreferenceStore pf = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling");
        this.setPreferenceStore((IPreferenceStore)pf);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public void createFieldEditors() {
        Group newItemGroup = new Group(this.getFieldEditorParent(), 0);
        newItemGroup.setText("Default settings for new subscription items");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)newItemGroup);
        FillLayout fl = new FillLayout();
        fl.marginWidth = 5;
        fl.marginHeight = 5;
        newItemGroup.setLayout((Layout)fl);
        Composite newItemSettings = new Composite((Composite)newItemGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(newItemSettings);
        this.fSubscriptionIntervalEditor = new NumberFieldEditor("subscriptionitem.interval", "Sampling Interval (s)", newItemSettings);
        this.fSubscriptionIntervalEditor.setValidRange(0.0, Double.MAX_VALUE);
        this.fSubscriptionIntervalEditor.setErrorMessage("Default sampling interval value is invalid");
        this.addField((FieldEditor)this.fSubscriptionIntervalEditor);
        this.fSubscriptionDeadbandEditor = new NumberFieldEditor("subscriptionitem.deadband", "Deadband", newItemSettings);
        this.fSubscriptionDeadbandEditor.setValidRange(0.0, Double.MAX_VALUE);
        this.fSubscriptionDeadbandEditor.setErrorMessage("Default deadband value is invalid");
        this.addField((FieldEditor)this.fSubscriptionDeadbandEditor);
        this.fSubscriptionGainEditor = new NumberFieldEditor("subscriptionitem.gain", "Gain", newItemSettings);
        this.addField((FieldEditor)this.fSubscriptionGainEditor);
        this.fSubscriptionBiasEditor = new NumberFieldEditor("subscriptionitem.bias", "Bias", newItemSettings);
        this.addField((FieldEditor)this.fSubscriptionBiasEditor);
        Group visualsGroup = new Group(this.getFieldEditorParent(), 0);
        visualsGroup.setText("Subscription related visualizations");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)visualsGroup);
        FillLayout vfl = new FillLayout();
        vfl.marginWidth = 5;
        vfl.marginHeight = 5;
        visualsGroup.setLayout((Layout)vfl);
        Composite visualSettings = new Composite((Composite)visualsGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(visualSettings);
        this.fSubscriptionShowValues = new BooleanFieldEditor("subscriptionitem.modelBrowser.showValue", "Show subscription item values in Model Browser", visualSettings);
        this.addField((FieldEditor)this.fSubscriptionShowValues);
        this.createNoteComposite(visualSettings, "Warning:", "Enabling this with lots of subscription items can slow the UI down heavily");
    }

    public void init(IWorkbench workbench) {
    }

    protected Composite createNoteComposite(Composite composite, String title, String message) {
        Composite messageComposite = new Composite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)messageComposite);
        Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(message);
        return messageComposite;
    }
}

