/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.Collection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.Messages;
import org.simantics.modeling.ui.diagramEditor.OpenDiagramFromConfigurationAdapter;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenDiagramFromSymbolAdapter
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.modeling.ui.symbolEditor";

    public OpenDiagramFromSymbolAdapter() {
        super(Messages.OpenDiagramFromSymbolAdapter_SymbolEditor, Activator.SYMBOL_ICON);
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        if (!g.isInheritedFrom(r, DiagramResource.getInstance((ReadGraph)g).DefinedElement)) {
            return false;
        }
        Resource componentType = g.getPossibleObject(r, ModelingResources.getInstance((ReadGraph)g).SymbolToComponentType);
        if (componentType == null) {
            return false;
        }
        return !OpenDiagramFromConfigurationAdapter.isLocked(g, componentType);
    }

    public void openEditor(final Resource r) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
                final Collection dias = g.getObjects(r, sr.IsDefinedBy);
                if (dias.isEmpty()) {
                    return;
                }
                final Resource model = (Resource)g.sync((ReadInterface)new PossibleIndexRoot(r));
                if (model == null) {
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (Resource dia : dias) {
                            try {
                                String editorId = OpenDiagramFromSymbolAdapter.this.getEditorId();
                                WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, dia, model, null));
                            }
                            catch (PartInitException e) {
                                ErrorLogger.defaultLogError((Throwable)e);
                            }
                        }
                    }
                });
            }
        });
    }
}

