/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.simantics.Simantics;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.actions.NavigateToTarget;
import org.simantics.modeling.actions.NavigationTargetChooserDialog;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.Messages;
import org.simantics.modeling.ui.diagramEditor.OpenDiagramFromConfigurationAdapter;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenDiagramFromComponentAdapter
extends AbstractResourceEditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenDiagramFromComponentAdapter.class);
    private static final String EDITOR_ID = "org.simantics.modeling.ui.diagramEditor";
    private static final Comparator<? super NamedResource> COMPARATOR = (o1, o2) -> AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName());

    public OpenDiagramFromComponentAdapter() {
        super(Messages.OpenDiagramFromComponentAdapter_OpenDiagramContainingComponent, Activator.SYMBOL_ICON);
    }

    protected String getEditorId(ReadGraph g, Resource diagram) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        String preferredEditorId = (String)g.getPossibleRelatedValue(diagram, MOD.PreferredDiagramEditorID);
        if (preferredEditorId != null) {
            return preferredEditorId;
        }
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph graph, Object input) throws DatabaseException {
        Pair<Resource, String> p = this.tryGetResource(graph, input);
        if (p == null) {
            return false;
        }
        Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)input, Variable.class);
        Collection<Runnable> rs = this.tryFindDiagram(graph, (Resource)p.first, v, (String)p.second);
        return !rs.isEmpty();
    }

    private Pair<Resource, String> tryGetResource(ReadGraph graph, Object input) throws DatabaseException {
        Resource r = ResourceAdaptionUtils.toSingleResource((Object)input);
        if (r != null) {
            return Pair.make((Object)r, (Object)"");
        }
        Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)input, Variable.class);
        return this.findResource(graph, v);
    }

    private Pair<Resource, String> findResource(ReadGraph graph, Variable v) throws DatabaseException {
        ArrayList<String> path = null;
        while (v != null) {
            Resource r = v.getPossibleRepresents(graph);
            if (r != null) {
                String rvi = "";
                if (path != null) {
                    int pathLength = path.size();
                    int i = 0;
                    while (i < pathLength) {
                        path.set(i, URIStringUtils.escape((String)((String)path.get(i))));
                        ++i;
                    }
                    Collections.reverse(path);
                    rvi = EString.implode(path, (String)"/");
                }
                return Pair.make((Object)r, (Object)rvi);
            }
            if (path == null) {
                path = new ArrayList<String>(2);
            }
            path.add(v.getName(graph));
            v = v.browsePossible(graph, ".");
        }
        return null;
    }

    public void openEditor(final Object input) throws Exception {
        final Display d = Display.getCurrent();
        if (d == null) {
            return;
        }
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Collection<Runnable> rs;
                Pair<Resource, String> r = OpenDiagramFromComponentAdapter.this.tryGetResource(graph, input);
                if (r == null) {
                    return;
                }
                Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)input, Variable.class);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".openEditor: input's nearest parent resource URI: " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)((Resource)r.first)));
                    LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".openEditor: input's nearest parent RVI: " + (String)r.second);
                    LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".openEditor: input variable URI: " + (v != null ? v.getURI(graph) : "null"));
                }
                if ((rs = OpenDiagramFromComponentAdapter.this.tryFindDiagram(graph, (Resource)r.first, v, (String)r.second)).isEmpty()) {
                    return;
                }
                SWTThread.getThreadAccess((Display)d).asyncExec(() -> rs.forEach(Runnable::run));
            }
        });
    }

    private Collection<Runnable> tryFindDiagram(ReadGraph g, Resource component, Variable variable, String rviFromComponent) throws DatabaseException {
        try {
            return this.findDiagram(g, component, variable, rviFromComponent);
        }
        catch (DatabaseException databaseException) {
            return Collections.emptyList();
        }
    }

    private Collection<Runnable> findDiagram(ReadGraph g, Resource component, Variable variable, String rviFromComponent) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        if (g.isInstanceOf(component, STR.Component)) {
            List<Resource> referenceElements;
            ArrayList<Runnable> result = new ArrayList<Runnable>(1);
            Resource composite = g.getSingleObject(component, l0.PartOf);
            Resource diagram = ComponentUtils.getPossibleCompositeDiagram((ReadGraph)g, (Resource)composite);
            String editorId = this.getEditorId(g, composite);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: component: " + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)component));
                LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: composite: " + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)composite));
            }
            Collection<Object> collection = referenceElements = diagram == null ? g.getObjects(component, MOD.HasParentComponent_Inverse) : Collections.emptyList();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: diagram: " + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)diagram));
                LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: referenceElements: " + referenceElements.size());
                for (Object e : referenceElements) {
                    LOGGER.debug("\t" + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)((Resource)e)));
                }
            }
            if (diagram == null && referenceElements.isEmpty()) {
                return Collections.emptyList();
            }
            Variable variable2 = Variables.getPossibleVariable((ReadGraph)g, (Resource)composite);
            if (variable2 == null) {
                return Collections.emptyList();
            }
            Resource indexRoot = Variables.getPossibleIndexRoot((ReadGraph)g, (Variable)variable2);
            if (indexRoot == null) {
                return Collections.emptyList();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: Model: " + indexRoot);
            }
            if (diagram != null) {
                if (OpenDiagramFromConfigurationAdapter.isLocked(g, diagram)) {
                    return Collections.emptyList();
                }
                RVI rvi = null;
                boolean allowNullRvi = false;
                if (variable != null) {
                    Variable parent;
                    Variable context = Variables.getPossibleContext((ReadGraph)g, (Variable)variable);
                    if (context != null && (parent = this.findFirstParentComposite(g, variable)) != null) {
                        rvi = parent.getPossibleRVI(g);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: resolved RVI: " + rvi);
                        }
                    }
                } else {
                    allowNullRvi = true;
                    rvi = variable2.getPossibleRVI(g);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: resolved RVI from resource path: " + rvi);
                    }
                }
                if (rvi == null && !allowNullRvi) {
                    return Collections.emptyList();
                }
                Collection<Object> selectedObjects = OpenDiagramFromComponentAdapter.findElementObjects(g, component, rviFromComponent);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: selected objects: " + selectedObjects.size());
                    for (Object object : selectedObjects) {
                        LOGGER.debug("\t" + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)((Resource)object)));
                    }
                }
                if (!selectedObjects.isEmpty()) {
                    result.add(NavigateToTarget.editorActivator((String)editorId, (Resource)diagram, (Resource)indexRoot, (RVI)rvi, this.editorActivationCallback(selectedObjects)));
                }
            } else {
                MapSet<NamedResource, Resource> referencingDiagrams = this.listReferenceDiagrams(g, referenceElements);
                Set diagrams = referencingDiagrams.getKeys();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".findDiagram: selected objects: " + diagrams.size());
                    for (NamedResource d : diagrams) {
                        LOGGER.debug("\t" + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)d.getResource()) + ":");
                        for (Resource referenceElement : referencingDiagrams.getValues((Object)d)) {
                            LOGGER.debug("\t\t" + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)referenceElement));
                        }
                    }
                }
                switch (diagrams.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        NamedResource singleDiagram = (NamedResource)diagrams.iterator().next();
                        RVI rvi = this.getDiagramCompositeRvi(g, singleDiagram.getResource());
                        if (rvi == null) break;
                        Set selectedObjects = referencingDiagrams.getValues((Object)singleDiagram);
                        result.add(NavigateToTarget.editorActivator((String)editorId, (Resource)singleDiagram.getResource(), (Resource)indexRoot, (RVI)rvi, this.editorActivationCallback(selectedObjects)));
                        break;
                    }
                    default: {
                        TreeMap<NamedResource, RVI> diagramToRvi = new TreeMap<NamedResource, RVI>(COMPARATOR);
                        for (NamedResource d : diagrams) {
                            RVI rvi2 = this.getDiagramCompositeRvi(g, d.getResource());
                            if (rvi2 == null) continue;
                            diagramToRvi.put((NamedResource)d, rvi2);
                        }
                        result.add(() -> {
                            NamedResource selected = this.queryTarget(WorkbenchUtils.getActiveWorkbenchWindowShell(), diagramToRvi.keySet());
                            if (selected != null) {
                                Set selectedObjects = referencingDiagrams.getValues((Object)selected);
                                RVI drvi = (RVI)diagramToRvi.get(selected);
                                NavigateToTarget.editorActivator((String)editorId, (Resource)selected.getResource(), (Resource)indexRoot, (RVI)drvi, this.editorActivationCallback(selectedObjects)).run();
                            }
                        });
                    }
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private RVI getDiagramCompositeRvi(ReadGraph graph, Resource diagram) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
        if (composite == null) {
            return null;
        }
        Variable v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)composite);
        return v != null ? v.getPossibleRVI(graph) : null;
    }

    private Consumer<IEditorPart> editorActivationCallback(Collection<? extends Object> selectedObjects) {
        return part -> {
            ICanvasContext openedCanvas = (ICanvasContext)part.getAdapter(ICanvasContext.class);
            assert (openedCanvas != null);
            openedCanvas.getDefaultHintContext().setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, (Object)Boolean.FALSE);
            ThreadUtils.asyncExec((IThreadWorkQueue)openedCanvas.getThreadAccess(), (Runnable)NavigateToTarget.elementSelectorZoomer((ICanvasContext)openedCanvas, (Collection)selectedObjects, (boolean)false));
        };
    }

    private Variable findFirstParentComposite(ReadGraph graph, Variable v) throws DatabaseException {
        Variable first = this.findFirstWithRepresentation(graph, v);
        if (first == null) {
            return null;
        }
        Variable parent = first.getParent(graph);
        return parent;
    }

    private Variable findFirstWithRepresentation(ReadGraph graph, Variable v) throws DatabaseException {
        while (v != null) {
            Resource represents = v.getPossibleRepresents(graph);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.valueOf(v.getURI(graph)) + " -> " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)represents));
            }
            if (represents != null) {
                return v;
            }
            v = v.getParent(graph);
        }
        return null;
    }

    public static Collection<Object> findElementObjects(ReadGraph g, Resource component, String rviFromComponent) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ArrayList<Object> selectedObjects = new ArrayList<Object>(4);
        if (rviFromComponent.isEmpty()) {
            for (Resource element : g.getObjects(component, MOD.ComponentToElement)) {
                if (g.isInstanceOf(element, DIA.Flag) && FlagUtil.isExternal((ReadGraph)g, (Resource)element)) {
                    selectedObjects.clear();
                    selectedObjects.add(element);
                    break;
                }
                if (g.isInstanceOf(element, DIA.RouteGraphConnection)) {
                    selectedObjects.add(element);
                    continue;
                }
                if (g.isInstanceOf(element, DIA.Connection)) {
                    ConnectionUtil cu = new ConnectionUtil(g);
                    cu.gatherConnectionParts(element, selectedObjects);
                    continue;
                }
                selectedObjects.add(element);
            }
        }
        return selectedObjects;
    }

    protected MapSet<NamedResource, Resource> listReferenceDiagrams(ReadGraph graph, Collection<Resource> referenceElements) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        MapSet.Tree diagrams = new MapSet.Tree(COMPARATOR);
        for (Resource referenceElement : referenceElements) {
            Variable v;
            Resource composite;
            Resource diagram = NavigateToTarget.getOwnerList((ReadGraph)graph, (Resource)referenceElement);
            if (diagram == null || (composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite)) == null || (v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)composite)) == null) continue;
            String rvi = URIStringUtils.unescape((String)Variables.getRVI((ReadGraph)graph, (Variable)v));
            diagrams.add((Object)new NamedResource(rvi, diagram), (Object)referenceElement);
        }
        return diagrams;
    }

    protected NamedResource queryTarget(Shell parentShell, Collection<NamedResource> options) {
        NavigationTargetChooserDialog dialog = new NavigationTargetChooserDialog(parentShell, options.toArray(new NamedResource[options.size()]), Messages.OpenDiagramFromComponentAdapter_ChooseDiagramComponetReference, Messages.OpenDiagramFromComponentAdapter_SelectSingleDiagramfromList);
        return dialog.open() != 0 ? null : dialog.getSelection();
    }
}

