/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.diagram.ui.WorkbenchSelectionProvider;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.ParentVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.ui.ErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramViewerSelectionProvider
extends WorkbenchSelectionProvider {
    protected DataContainer<IDiagram> sourceDiagram;

    public DiagramViewerSelectionProvider(IThreadWorkQueue queue, IWorkbenchPartSite site, DataContainer<IDiagram> sourceDiagram) {
        super(queue, site);
        assert (sourceDiagram != null);
        this.sourceDiagram = sourceDiagram;
    }

    protected ISelection constructAdaptableSelection(Iterable<?> selection) {
        ArrayList<SelectionElement> objects = new ArrayList<SelectionElement>();
        IDiagram diagram = (IDiagram)this.sourceDiagram.get();
        if (diagram != null) {
            Resource runtime = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
            Resource dr = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
            for (Object o : selection) {
                Resource resource = this.getSelectionResource(o);
                if (resource != null) {
                    objects.add(DiagramViewerSelectionProvider.constructSelectionElement(runtime, resource));
                    continue;
                }
                System.out.println("  unrecognized selection: " + o.getClass() + ": " + o);
            }
            if (objects.isEmpty() && runtime != null && dr != null) {
                objects.add(DiagramViewerSelectionProvider.constructSelectionElement(runtime, dr));
            }
        }
        return new StructuredSelection(objects);
    }

    protected Resource getSelectionResource(Object o) {
        if (o instanceof IElement) {
            IElement e = (IElement)o;
            Object object = e.getHint(ElementHints.KEY_OBJECT);
            if (object instanceof Resource) {
                return (Resource)object;
            }
            object = ElementUtils.adaptElement((IElement)e, Resource.class);
            if (object != null) {
                return (Resource)object;
            }
        }
        return null;
    }

    protected static SelectionElement constructSelectionElement(Resource runtime, Resource object) {
        SelectionElement context = new SelectionElement(SelectionHints.STD_KEYS, runtime, object);
        context.setHint(SelectionHints.KEY_MAIN, object);
        if (runtime != null) {
            context.setHint(SelectionHints.KEY_VARIABLE_RESOURCE, runtime);
            try {
                Resource model = (Resource)RequestUtil.trySyncRequest((Session)Simantics.getSession(), (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, null, (Read)new ModelOfRuntime(runtime));
                if (model != null) {
                    context.setHint(SelectionHints.KEY_MODEL, model);
                }
            }
            catch (InterruptedException | DatabaseException ex) {
                ErrorLogger.defaultLogError((Throwable)ex);
            }
        }
        return context;
    }

    private static class ModelOfRuntime
    extends ResourceRead<Resource> {
        public ModelOfRuntime(Resource runtime) {
            super(runtime);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            Resource resource;
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            String uri = (String)graph.getPossibleRelatedValue(this.resource, DIA.RuntimeDiagram_HasModelURI);
            if (uri != null && (resource = graph.getPossibleResource(uri)) != null) {
                return resource;
            }
            Resource diagram = graph.getPossibleObject(this.resource, DIA.RuntimeDiagram_HasConfiguration);
            if (diagram == null) {
                return null;
            }
            return (Resource)graph.syncRequest((Read)new PossibleModel(diagram));
        }
    }

    protected static class SelectionElement
    extends AdaptableHintContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(SelectionElement.class);
        public final Resource runtime;
        public final Resource element;

        public SelectionElement(IHintContext.Key[] keys, Resource runtime, Resource element) {
            super(keys);
            this.runtime = runtime;
            this.element = element;
        }

        public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
            if (contentType instanceof AnyResource) {
                return (T)this.element;
            }
            if (contentType instanceof AnyVariable) {
                AnyVariable type = (AnyVariable)contentType;
                try {
                    return (T)type.processor.sync((ReadInterface)new ResourceRead2<Variable>(this.runtime, this.element){

                        public Variable perform(ReadGraph graph) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            String uri = (String)graph.getPossibleRelatedValue(this.resource, DIA.RuntimeDiagram_HasVariable);
                            if (uri == null) {
                                return null;
                            }
                            Variable var = Variables.getPossibleVariable((ReadGraph)graph, (String)uri);
                            if (var == null) {
                                return null;
                            }
                            Resource config = graph.getPossibleObject(this.resource2, MOD.ElementToComponent);
                            if (config == null) {
                                Variable signal;
                                Variable v;
                                if (graph.isInstanceOf(this.resource2, DIA.Connection) && (v = FlagUtil.getPossibleConnectionSignal((ReadGraph)graph, (Variable)var, (Resource)this.resource2, (Resource)L0.Entity)) != null) {
                                    return v;
                                }
                                Resource composite = graph.getPossibleObject(this.resource2, MOD.DiagramToComposite);
                                if (composite != null && composite.equals(var.getPossibleRepresents(graph))) {
                                    return var;
                                }
                                if (graph.isInstanceOf(this.resource2, DIA.Flag) && (signal = FlagUtil.getPossibleFlagSignal((ReadGraph)graph, (Variable)var, (Resource)this.resource2, (Resource)L0.Entity)) != null) {
                                    return signal;
                                }
                                return null;
                            }
                            return var.browsePossible(graph, config);
                        }
                    });
                }
                catch (DatabaseException e) {
                    LOGGER.error("WorkbenchSelectionElement.getContent failed for type AnyVariable", (Throwable)e);
                }
            } else if (contentType instanceof ParentVariable) {
                ParentVariable type = (ParentVariable)contentType;
                try {
                    return (T)type.processor.sync((ReadInterface)new ResourceRead2<Variable>(this.runtime, this.element){

                        public Variable perform(ReadGraph graph) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                            String uri = (String)graph.getPossibleRelatedValue(this.resource, DIA.RuntimeDiagram_HasVariable);
                            if (uri == null) {
                                return null;
                            }
                            Variable var = Variables.getPossibleVariable((ReadGraph)graph, (String)uri);
                            if (var == null) {
                                return null;
                            }
                            return var;
                        }
                    });
                }
                catch (DatabaseException e) {
                    LOGGER.error("WorkbenchSelectionElement.getContent failed for type ParentVariable", (Throwable)e);
                }
            }
            return null;
        }
    }
}

