/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.elements.DecorationSVGNode;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.handler.Paster;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.issues.Severity;
import org.simantics.issues.common.IssueResourcesContexts;
import org.simantics.issues.common.ListModelIssuesBySeverity;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.map.Tuple;

public class IssueDecorationStyle
extends StyleBase<IssueResult> {
    private static final String DECORATION_NODE_NAME = "issueDecorations";
    private static final Class[] IGNORED_NODES_FOR_POSITION = new Class[]{Decoration.class, TextNode.class};

    protected List<Resource> getContexts(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>(3);
        result.add(element);
        Resource config = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (config != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.DiagramConnectionToConnection)) != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.HasParentComponent)) != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        return result;
    }

    public IssueResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)configuration);
        if (model == null) {
            return null;
        }
        List<Resource> contexts = this.getContexts(graph, element);
        Map issuesBySeverity = (Map)graph.syncRequest((Read)new ListModelIssuesBySeverity(model, true, true, Severity.NOTE), (Listener)TransientCacheListener.instance());
        Severity[] severityArray = Severity.values();
        int n = severityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set issueContexts;
            Severity severity = severityArray[n2];
            List issues = (List)issuesBySeverity.get(severity);
            if (issues != null && !Collections.disjoint(issueContexts = (Set)graph.syncRequest((Read)new IssueResourcesContexts((Collection)issues)), contexts)) {
                return new IssueResult(severity, IssueDecorationStyle.getIdentifier(graph, runtimeDiagram, element));
            }
            ++n2;
        }
        return null;
    }

    private static Object getIdentifier(ReadGraph graph, Resource runtimeDiagram, Resource element) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, DIA.RouteGraphConnection)) {
            Collection connectors = graph.getObjects(element, DIA.HasConnector);
            Collection routeNodes = graph.getObjects(element, DIA.HasInteriorRouteNode);
            HashSet<AffineTransform> identifier = new HashSet<AffineTransform>(connectors.size() + routeNodes.size());
            for (Resource connector : connectors) {
                for (Resource connectedTo : graph.getObjects(connector, STR.Connects)) {
                    if (connectedTo.equals(element)) continue;
                    AffineTransform at = DiagramGraphUtil.getDynamicAffineTransform((ReadGraph)graph, (Resource)runtimeDiagram, (Resource)connectedTo, (Resource)DIA.HasDynamicTransform, (boolean)false);
                    identifier.add(at);
                }
            }
            for (Resource routeLine : routeNodes) {
                Paster.RouteLine rl = Paster.readRouteLine((ReadGraph)graph, (Resource)routeLine);
                identifier.add((AffineTransform)rl);
            }
            return identifier;
        }
        return DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
    }

    public void applyStyleForNode(EvaluationContext observer, INode node, IssueResult result) {
        if (result == null) {
            ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
            return;
        }
        SVGNode svgNode = (SVGNode)ProfileVariables.claimChild((INode)node, (String)"", (String)DECORATION_NODE_NAME, DecorationSVGNode.class, (Observer)observer);
        svgNode.setZIndex(Integer.MAX_VALUE);
        svgNode.setTransform(this.getDecorationPosition(node));
        String svgData = this.svgDataForSeverity(result.getSeverity());
        if (svgData != null) {
            svgNode.setData(svgData);
        }
    }

    protected AffineTransform getDecorationPosition(INode node) {
        Rectangle2D bounds = NodeUtil.getLocalBounds((INode)node, (Class[])IGNORED_NODES_FOR_POSITION);
        if (node instanceof ConnectionNode) {
            IG2DNode[] iG2DNodeArray = ((ConnectionNode)node).getSortedNodes();
            int n = iG2DNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RouteGraphNode rgn;
                RouteGraph rg;
                Point2D nearest;
                IG2DNode child = iG2DNodeArray[n2];
                if (child instanceof RouteGraphNode && (nearest = (rg = (rgn = (RouteGraphNode)child).getRouteGraph()).findNearestPoint(bounds.getCenterX(), bounds.getCenterY())) != null) {
                    return AffineTransform.getTranslateInstance(nearest.getX(), nearest.getY());
                }
                ++n2;
            }
        }
        double tx = bounds.getX();
        double ty = bounds.getY();
        return AffineTransform.getTranslateInstance(tx, ty);
    }

    protected String svgDataForSeverity(Severity s) {
        switch (s) {
            case FATAL: {
                return Activator.FATAL_SVG_TEXT;
            }
            case ERROR: {
                return Activator.ERROR_SVG_TEXT;
            }
            case WARNING: {
                return Activator.WARNING_SVG_TEXT;
            }
            case INFO: {
                return Activator.INFO_SVG_TEXT;
            }
            case NOTE: {
                return Activator.NOTE_SVG_TEXT;
            }
        }
        return null;
    }

    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
    }

    public String toString() {
        return "Issue decoration";
    }

    public static class IssueResult
    extends Tuple {
        public IssueResult(Severity severity, Object identifier) {
            super(new Object[]{severity, identifier});
        }

        public Severity getSeverity() {
            return (Severity)this.getField(0);
        }
    }
}

