/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.DecimalFormatFormatter;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.VariableException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.diagram.monitor.MonitorVariable;
import org.simantics.operation.Layer0X;

public class ResolveMonitorVariable
extends BinaryRead<Resource, Resource, MonitorVariable> {
    public ResolveMonitorVariable(Resource runtimeDiagram, Resource monitorElement) {
        super((Object)runtimeDiagram, (Object)monitorElement);
    }

    public MonitorVariable perform(ReadGraph graph) throws DatabaseException {
        Boolean external = null;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource monitorComponent = graph.getPossibleObject((Resource)this.parameter2, DIA.HasMonitorComponent);
        if (monitorComponent == null) {
            return null;
        }
        String suffix = (String)graph.getPossibleRelatedValue((Resource)this.parameter2, DIA.HasMonitorSuffix, (Binding)Bindings.STRING);
        if (suffix == null) {
            return null;
        }
        String diagramVariable = (String)graph.getPossibleRelatedValue((Resource)this.parameter, DIA.RuntimeDiagram_HasVariable);
        if (diagramVariable == null) {
            return null;
        }
        Variable var = Variables.getPossibleVariable((ReadGraph)graph, (String)diagramVariable);
        if (var == null) {
            return null;
        }
        Variable component = var.browsePossible(graph, monitorComponent);
        if (component == null) {
            component = Variables.getPossibleVariable((ReadGraph)graph, (Resource)monitorComponent);
            if (component == null) {
                return null;
            }
            String componentRVI = Variables.getPossibleRVI((ReadGraph)graph, (Variable)component);
            if (componentRVI == null) {
                return null;
            }
            Resource realization = Variables.getRealization((ReadGraph)graph, (Variable)var);
            String diagramRealizationURI = graph.getPossibleURI(realization);
            if (diagramRealizationURI == null) {
                return null;
            }
            String componentURI = String.valueOf(diagramRealizationURI) + componentRVI;
            var = Variables.getPossibleVariable((ReadGraph)graph, (String)componentURI);
            if (var == null) {
                return null;
            }
            external = Boolean.TRUE;
        } else {
            var = component;
        }
        var = var.browsePossible(graph, suffix);
        if (var == null) {
            return null;
        }
        Formatter formatter = (Formatter)graph.getPossibleRelatedAdapter((Resource)this.parameter2, DIA.HasFormatter, Formatter.class);
        if (formatter == null) {
            formatter = new DecimalFormatFormatter();
        }
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        String _expression = (String)graph.getPossibleRelatedAdapter((Resource)this.parameter2, L0X.HasExpression, String.class);
        if (_expression == null) {
            _expression = "value";
        }
        RVI rvi = null;
        try {
            rvi = Variables.getRVI2((ReadGraph)graph, (Variable)var);
        }
        catch (VariableException variableException) {}
        return new MonitorVariable(monitorComponent, formatter, _expression, var, rvi, external);
    }
}

