/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;

public class SCLModuleEditorDocumentProvider
extends AbstractDocumentProvider {
    protected Resource resource;
    protected String currentText;
    protected boolean immutable;
    protected boolean errorHappened;
    protected AnnotationModel annotationModel = new AnnotationModel();
    private final SCLSourceViewerConfigurationNew sourceViewer;
    private UpdateListener listener = new UpdateListener(){

        public void notifyAboutUpdate() {
            SCLModuleEditorDocumentProvider.this.updateAnnotations();
        }
    };
    boolean annotationsInitialized = false;

    public SCLModuleEditorDocumentProvider(SCLSourceViewerConfigurationNew sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        this.resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    SCLModuleEditorDocumentProvider.this.currentText = (String)graph.getRelatedValue(SCLModuleEditorDocumentProvider.this.resource, L0.SCLModule_definition, (Binding)Bindings.STRING);
                    SCLModuleEditorDocumentProvider.this.immutable = StructuralUtils.isImmutable((ReadGraph)graph, (Resource)SCLModuleEditorDocumentProvider.this.resource);
                    SCLModuleEditorDocumentProvider.this.errorHappened = false;
                    return new Document(SCLModuleEditorDocumentProvider.this.currentText != null ? SCLModuleEditorDocumentProvider.this.currentText : "");
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.errorHappened = true;
            return new Document(sw.toString());
        }
    }

    protected void updateAnnotations() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                if (!graph.hasStatement(SCLModuleEditorDocumentProvider.this.resource)) {
                    return;
                }
                String moduleName = graph.getURI(SCLModuleEditorDocumentProvider.this.resource);
                SCLContext context = SCLContext.getCurrent();
                context.put((Object)"graph", (Object)graph);
                Failable result = SCLOsgi.MODULE_REPOSITORY.getModule(moduleName, SCLModuleEditorDocumentProvider.this.listener);
                if (result instanceof Failure) {
                    Failure failure = (Failure)result;
                    SCLModuleEditorDocumentProvider.this.setAnnotations(Arrays.asList(failure.errors));
                } else {
                    SCLModuleEditorDocumentProvider.this.setAnnotations(Collections.emptyList());
                }
                SCLModuleEditorDocumentProvider.this.sourceViewer.updateCompletionAssistModuleName(moduleName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(List<CompilationError> errors) {
        Object object = this.annotationModel.getLockObject();
        synchronized (object) {
            this.annotationModel.removeAllAnnotations();
            for (CompilationError error : errors) {
                Annotation annotation = new Annotation("org.eclipse.ui.workbench.texteditor.error", true, error.description);
                int begin = Locations.beginOf((long)error.location);
                int end = Locations.endOf((long)error.location);
                Position position = new Position(begin, end - begin);
                this.annotationModel.addAnnotation(annotation, position);
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (!this.annotationsInitialized) {
            this.updateAnnotations();
            this.annotationsInitialized = true;
        }
        return this.annotationModel;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog((String)"SCLModuleEditorDocumentProvider.doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                graph.claimLiteral(SCLModuleEditorDocumentProvider.this.resource, L0.SCLModule_definition, (Object)SCLModuleEditorDocumentProvider.this.currentText, (Binding)Bindings.STRING);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Saved SCL Module " + graph.getRelatedValue2(SCLModuleEditorDocumentProvider.this.resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
            }
        });
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.errorHappened && !this.immutable;
    }

    public boolean isReadOnly(Object element) {
        return this.errorHappened || this.immutable;
    }
}

