/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.ui.BundleUtils;

public abstract class ExplorerDynamicMenuContribution<T>
extends DynamicMenuContribution {
    private static final IContributionItem[] NONE = new IContributionItem[0];

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        T input = this.computeInput(graph, selection);
        if (input == null) {
            return NONE;
        }
        return new IContributionItem[]{new ActionContributionItem((IAction)new Helper(graph, input))};
    }

    protected ImageDescriptor silk(String name) {
        return BundleUtils.getImageDescriptorFromBundle((Bundle)Platform.getBundle((String)"com.famfamfam.silk"), (String)("/icons/" + name));
    }

    protected abstract T computeInput(ReadGraph var1, Object[] var2) throws DatabaseException;

    protected abstract void perform(Session var1, T var2);

    protected abstract String getName(ReadGraph var1, T var2) throws DatabaseException;

    protected abstract ImageDescriptor getImage(ReadGraph var1, T var2) throws DatabaseException;

    public class Helper
    extends Action {
        private final T input;
        protected final Session session;

        public Helper(ReadGraph graph, T input) throws DatabaseException {
            super(ExplorerDynamicMenuContribution.this.getName(graph, input), ExplorerDynamicMenuContribution.this.getImage(graph, input));
            this.session = graph.getSession();
            this.input = input;
        }

        public void run() {
            ExplorerDynamicMenuContribution.this.perform(this.session, this.input);
        }
    }
}

