/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.AssignSymbolGroupRequest;
import org.simantics.modeling.GetSymbolGroups;
import org.simantics.modeling.NewSymbolGroupRequest;
import org.simantics.modeling.ui.actions.AssignSymbolGroupsDialog;
import org.simantics.modeling.ui.actions.Messages;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class AssignSymbolGroup
implements ActionFactory,
ActionFactory2 {
    private static final SymbolGroup[] NO_SYMBOL_GROUPS = new SymbolGroup[0];

    public Runnable create(Collection<?> targets) {
        final ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Object target : targets) {
            if (!(target instanceof Resource)) {
                return null;
            }
            resources.add((Resource)target);
        }
        return new Runnable(){

            @Override
            public void run() {
                AssignSymbolGroup.this.assignGroups(resources);
            }
        };
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource symbol = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                AssignSymbolGroup.this.assignGroups(Collections.singletonList(symbol));
            }
        };
    }

    private static Resource getCommonModel(final Collection<Resource> symbols) {
        try {
            return (Resource)Simantics.sync((ReadInterface)new UniqueRead<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return AssignSymbolGroup.getPossibleIndexRoot(graph, symbols);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    private static Resource getPossibleIndexRoot(ReadGraph g, Collection<Resource> symbols) throws DatabaseException {
        Resource model = null;
        for (Resource symbol : symbols) {
            Resource m = AssignSymbolGroup.getIndexRootOf(g, symbol);
            if (m == null) {
                return null;
            }
            if (model == null) {
                model = m;
                continue;
            }
            if (model.equals(m)) continue;
            return null;
        }
        return model;
    }

    private static Resource getIndexRootOf(ReadGraph g, Resource symbol) throws DatabaseException {
        return (Resource)g.syncRequest((Read)new PossibleIndexRoot(symbol));
    }

    private static SymbolGroup[] getSymbolGroups(final Collection<Resource> symbols) {
        try {
            return (SymbolGroup[])Simantics.getSession().syncRequest((Read)new Read<SymbolGroup[]>(){

                public SymbolGroup[] perform(ReadGraph g) throws DatabaseException {
                    return AssignSymbolGroup.getSymbolGroups(g, symbols);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return NO_SYMBOL_GROUPS;
        }
    }

    private static SymbolGroup[] getSymbolGroups(ReadGraph g, Collection<Resource> symbols) throws DatabaseException {
        Resource model = AssignSymbolGroup.getPossibleIndexRoot(g, symbols);
        if (model == null) {
            return NO_SYMBOL_GROUPS;
        }
        ArrayList<SymbolGroup> result = new ArrayList<SymbolGroup>();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        for (Resource library : GetSymbolGroups.getSymbolGroups((ReadGraph)g, (Resource)model)) {
            Tristate selected = AssignSymbolGroup.getLibrarySelectionState(g, library, symbols, DIA);
            selected = selected != null ? selected : Tristate.NONE;
            result.add(new SymbolGroup(library, NameUtils.getSafeLabel((ReadGraph)g, (Resource)library), selected, selected));
        }
        Collections.sort(result);
        return result.toArray(new SymbolGroup[result.size()]);
    }

    protected static Tristate getLibrarySelectionState(ReadGraph graph, Resource library, Collection<Resource> symbols, DiagramResource DIA) throws DatabaseException {
        Tristate selected = null;
        for (Resource symbol : symbols) {
            selected = Tristate.add(selected, graph.hasStatement(library, DIA.HasSymbol, symbol));
        }
        return selected != null ? selected : Tristate.NONE;
    }

    private static SymbolGroup[] selectedElements(SymbolGroup[] symbolGroups) {
        int count = 0;
        SymbolGroup[] symbolGroupArray = symbolGroups;
        int n = symbolGroups.length;
        int n2 = 0;
        while (n2 < n) {
            SymbolGroup g = symbolGroupArray[n2];
            if (g.selected != Tristate.NONE) {
                ++count;
            }
            ++n2;
        }
        SymbolGroup[] result = new SymbolGroup[count];
        count = 0;
        SymbolGroup[] symbolGroupArray2 = symbolGroups;
        int n3 = symbolGroups.length;
        n = 0;
        while (n < n3) {
            SymbolGroup g = symbolGroupArray2[n];
            if (g.selected != Tristate.NONE) {
                result[count++] = g;
            }
            ++n;
        }
        return result;
    }

    public void assignGroups(Collection<Resource> symbols) {
        if (symbols.isEmpty()) {
            return;
        }
        final Resource model = AssignSymbolGroup.getCommonModel(symbols);
        if (model == null) {
            ShowMessage.showInformation((String)Messages.AssignSymbolGroup_SameModelRequired, (String)Messages.AssignSymbolGroup_SameModelRequiredMsg);
            return;
        }
        final AtomicReference<SymbolGroup[]> groups = new AtomicReference<SymbolGroup[]>(AssignSymbolGroup.getSymbolGroups(symbols));
        String message = symbols.size() > 1 ? NLS.bind((String)Messages.AssignSymbolGroup_SelectSymbolGroupsTheSelectedSymbolsAreShownIn, (Object)symbols.size()) : Messages.AssignSymbolGroup_SelectSymbolGroupsTheSelectedSymbolIsShownIn;
        AssignSymbolGroupsDialog dialog = new AssignSymbolGroupsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), groups.get(), new ContentProviderImpl(), (ILabelProvider)new LabelProviderImpl(), new CheckStateProviderImpl(), message.toString()){

            @Override
            protected void checkStateChanged(Object[] elements, boolean checked) {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object _g = objectArray[n2];
                    SymbolGroup g = (SymbolGroup)_g;
                    g.selected = checked ? Tristate.ALL : Tristate.NONE;
                    this.listViewer.refresh();
                    ++n2;
                }
            }

            @Override
            protected void newAction() {
                SymbolGroup newGroup = AssignSymbolGroup.newSymbolGroup(this.getShell(), model, (SymbolGroup[])this.inputElement);
                if (newGroup != null) {
                    newGroup.selected = Tristate.ALL;
                    Object[] newGroups = (SymbolGroup[])this.inputElement;
                    newGroups = Arrays.copyOf(newGroups, newGroups.length + 1);
                    newGroups[newGroups.length - 1] = newGroup;
                    Arrays.sort(newGroups);
                    this.listViewer.setInput((Object)newGroups);
                    this.inputElement = newGroups;
                    groups.set(newGroups);
                }
            }

            @Override
            protected void deleteAction(Object[] array) {
                Object[] groupsToRemove = (SymbolGroup[])Arrays.copyOf(array, array.length, SymbolGroup[].class);
                if (AssignSymbolGroup.this.removeSymbolGroups(this.getShell(), (SymbolGroup[])groupsToRemove)) {
                    this.listViewer.remove(groupsToRemove);
                    HashSet<Object> removedGroups = new HashSet<Object>();
                    Object[] objectArray = groupsToRemove;
                    int n = groupsToRemove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object removed = objectArray[n2];
                        removedGroups.add(removed);
                        ++n2;
                    }
                    ArrayList<SymbolGroup> newGroups = new ArrayList<SymbolGroup>(((SymbolGroup[])groups.get()).length);
                    SymbolGroup[] symbolGroupArray = (SymbolGroup[])groups.get();
                    int n3 = symbolGroupArray.length;
                    n = 0;
                    while (n < n3) {
                        SymbolGroup old = symbolGroupArray[n];
                        if (!removedGroups.contains(old)) {
                            newGroups.add(old);
                        }
                        ++n;
                    }
                    groups.set(newGroups.toArray(NO_SYMBOL_GROUPS));
                }
            }
        };
        dialog.setTitle(Messages.AssignSymbolGroup_SymbolGroupAssignments);
        dialog.setInitialSelections(AssignSymbolGroup.selectedElements(groups.get()));
        if (dialog.open() == 0) {
            ArrayList<SymbolGroup> added = new ArrayList<SymbolGroup>();
            ArrayList<SymbolGroup> removed = new ArrayList<SymbolGroup>();
            SymbolGroup[] symbolGroupArray = groups.get();
            int n = symbolGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                SymbolGroup g = symbolGroupArray[n2];
                if (g.selected != g.originallySelected && g.selected == Tristate.ALL) {
                    added.add(g);
                }
                if (g.selected != g.originallySelected && g.selected == Tristate.NONE) {
                    removed.add(g);
                }
                ++n2;
            }
            if (!added.isEmpty() || !removed.isEmpty()) {
                ArrayList<Resource> addedSymbolGroups = new ArrayList<Resource>();
                ArrayList<Resource> removedSymbolGroups = new ArrayList<Resource>();
                for (SymbolGroup group : added) {
                    addedSymbolGroups.add(group.resource);
                }
                for (SymbolGroup group : removed) {
                    removedSymbolGroups.add(group.resource);
                }
                Simantics.getSession().asyncRequest((Write)new AssignSymbolGroupRequest(addedSymbolGroups, removedSymbolGroups, symbols));
            }
        }
    }

    private static SymbolGroup newSymbolGroup(Shell shell, Resource model, final SymbolGroup[] oldGroups) {
        InputDialog dialog = new InputDialog(shell, Messages.AssignSymbolGroup_NewSymbolGroup, Messages.AssignSymbolGroup_WriteSymbolGroupName, "NewSymbolGroup", new IInputValidator(){

            public String isValid(String newText) {
                if ((newText = newText.trim()).isEmpty()) {
                    return Messages.AssignSymbolGroup_NameMustNotBeEmpty;
                }
                SymbolGroup[] symbolGroupArray = oldGroups;
                int n = oldGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    SymbolGroup g = symbolGroupArray[n2];
                    if (newText.equals(g.name)) {
                        return Messages.AssignSymbolGroup_GroupSymbolAlreadyExists;
                    }
                    ++n2;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            Resource symbolGroup;
            String name;
            block4: {
                name = dialog.getValue();
                try {
                    NewSymbolGroupRequest request = new NewSymbolGroupRequest(name, model);
                    symbolGroup = (Resource)Simantics.getSession().syncRequest((WriteResult)request);
                    if (symbolGroup != null) break block4;
                    return null;
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                    return null;
                }
            }
            return new SymbolGroup(symbolGroup, name, Tristate.NONE, Tristate.NONE);
        }
        return null;
    }

    private boolean removeSymbolGroups(Shell shell, final SymbolGroup[] groups) {
        if (groups.length == 0) {
            return false;
        }
        String message = groups.length == 1 ? NLS.bind((String)Messages.AssignSymbolGroup_AreYouSureToRemoveSymbolGroup, (Object)groups[0].name) : NLS.bind((String)Messages.AssignSymbolGroup_AreYouSureToRemoveSymbolGroup1, (Object)groups.length);
        MessageDialog dialog = new MessageDialog(shell, Messages.AssignSymbolGroup_ConfirmRemoval, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        if (dialog.open() == 0) {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SymbolGroup[] symbolGroupArray = groups;
                    int n = groups.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SymbolGroup group = symbolGroupArray[n2];
                        graph.deny(group.resource);
                        ++n2;
                    }
                }
            });
            return true;
        }
        return false;
    }

    private static class CheckStateProviderImpl
    implements ICheckStateProvider {
        private CheckStateProviderImpl() {
        }

        public boolean isChecked(Object element) {
            return ((SymbolGroup)element).selected != Tristate.NONE;
        }

        public boolean isGrayed(Object element) {
            return ((SymbolGroup)element).selected == Tristate.SOME;
        }
    }

    private static class ContentProviderImpl
    implements IStructuredContentProvider {
        private ContentProviderImpl() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private static class LabelProviderImpl
    extends LabelProvider {
        private LabelProviderImpl() {
        }

        public String getText(Object element) {
            return ((SymbolGroup)element).name;
        }
    }

    private static class SymbolGroup
    implements Comparable<SymbolGroup> {
        Resource resource;
        String name;
        Tristate originallySelected;
        Tristate selected;

        public SymbolGroup(Resource resource, String name, Tristate originallySelected, Tristate selected) {
            this.resource = resource;
            this.name = name;
            this.originallySelected = originallySelected;
            this.selected = selected;
        }

        @Override
        public int compareTo(SymbolGroup o) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)this.name, (Object)o.name);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[name=" + this.name + ", originally selected=" + (Object)((Object)this.originallySelected) + ", selected=" + (Object)((Object)this.selected) + "]";
        }
    }

    static enum Tristate {
        NONE,
        SOME,
        ALL;


        public static Tristate add(Tristate current, boolean next) {
            if (current == null) {
                return next ? ALL : NONE;
            }
            switch (current) {
                case ALL: {
                    return next ? ALL : SOME;
                }
                case SOME: {
                    return next ? SOME : SOME;
                }
                case NONE: {
                    return next ? SOME : NONE;
                }
            }
            return NONE;
        }
    }
}

