/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.tests.commands;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.testing.common.Command;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.UriResourceTrait;

public abstract class ResourceWriteCommand<T extends CommandSequenceEnvironment>
extends Command<T>
implements SingleResourceTrait {
    private Resource resource;

    public final void run(T environment) throws Exception {
        this.resource = this.runResource(environment);
        this.afterRun(environment);
    }

    public Resource runResource(final T environment) throws Exception {
        return (Resource)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                return ResourceWriteCommand.this.run(graph, environment);
            }

            public String toString() {
                return ResourceWriteCommand.this.toString();
            }
        });
    }

    protected Resource run(WriteGraph graph, T environment) throws DatabaseException {
        throw new IllegalStateException();
    }

    protected void afterRun(T environment) throws Exception {
    }

    public String toString() {
        return "ResourceWriteCommand " + this.getClass().getSimpleName();
    }

    @Override
    public Resource getResource() throws DatabaseException {
        return this.resource;
    }

    @Override
    public Resource getResource(ReadGraph graph) throws DatabaseException {
        return this.resource;
    }

    @Override
    public SingleResourceTrait child(String path) {
        return new UriResourceTrait(this, path);
    }
}

