/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.tests.commands;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.tests.commands.ResourceWriteCommand;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.WorkerThread;

public class LoadDiagram
extends ResourceWriteCommand<CommandSequenceEnvironment>
implements SingleResourceTrait {
    private static final boolean DEBUG = true;
    private SingleResourceTrait diagram;
    private transient ICanvasSceneGraphProvider provider;
    private transient CanvasContext ctx;
    private transient IActivation activation;
    private transient WorkerThread workerThread;

    public LoadDiagram(SingleResourceTrait diagram) {
        this.diagram = diagram;
    }

    public LoadDiagram(Resource diagram) {
        this(new SingleResourceTraitImpl(diagram));
    }

    @Override
    public Resource runResource(CommandSequenceEnvironment environment) throws DatabaseException {
        try {
            Resource model = (Resource)Simantics.sync((ReadInterface)new Model(this.diagram.getResource()));
            String diagramName = (String)Simantics.sync((ReadInterface)new ResourceRead<String>(this.diagram.getResource()){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    Resource composite = graph.getPossibleObject(this.resource, MOD.DiagramToComposite);
                    return (String)graph.getPossibleRelatedValue(composite, L0.HasName, (Binding)Bindings.STRING);
                }
            });
            System.out.println("DEBUG: load " + diagramName);
            this.workerThread = new WorkerThread("Load diagram");
            this.workerThread.start();
            this.ctx = new CanvasContext((IThreadWorkQueue)this.workerThread);
            this.provider = DiagramNodeUtil.loadSceneGraphProvider((ICanvasContext)this.ctx, (Resource)model, (Resource)this.diagram.getResource(), (String)("/" + diagramName));
            IActivationManager activationManager = (IActivationManager)Simantics.getSession().peekService(IActivationManager.class);
            if (activationManager != null) {
                this.activation = activationManager.activate(this.diagram.getResource());
            }
        }
        catch (InterruptedException e) {
            throw new DatabaseException((Throwable)e);
        }
        return this.diagram.getResource();
    }

    public ICanvasSceneGraphProvider getProvider() {
        return this.provider;
    }

    public IActivation getActivation() {
        return this.activation;
    }

    public CanvasContext getContext() {
        return this.ctx;
    }

    public WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    public IDiagram getDiagram() {
        return (IDiagram)this.ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
    }
}

