package org.simantics.modeling.tests.traits;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;

public class DiagramElementTrait extends AbstractSingleResourceTrait {
	
	public SingleResourceTrait diagram;
	public String name;
	
	public DiagramElementTrait(SingleResourceTrait diagram, String name) {
		this.diagram = diagram;
		this.name = name;
	}
	
	@Override
	public Resource getResource(ReadGraph graph) throws DatabaseException {
		ModelingResources MOD = ModelingResources.getInstance(graph);
		Resource composite = graph.getSingleObject(diagram.getResource(), MOD.DiagramToComposite);
		Resource child = graph.sync(new UnescapedChildMapOfResource(composite)).get(name);
		if(child == null) throw new DatabaseException("No child " + child + " for " + NameUtils.getSafeName(graph, composite));
		return graph.getSingleObject(child, MOD.ComponentToElement);
	}
	
}
