package org.simantics.modeling.tests.commands;

import java.util.ArrayList;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;
import org.simantics.structural.stubs.StructuralResource2;

public class MergeFlags extends WriteCommand<CommandSequenceEnvironment> {

	private SingleResourceTrait diagram;
	
	public MergeFlags(SingleResourceTrait diagram) {
		this.diagram = diagram;
	}
	
	public MergeFlags(Resource diagram) {
		this(new SingleResourceTraitImpl(diagram));
	}

	public Resource getComposite(ReadGraph graph) throws DatabaseException {
		DiagramResource DIA = DiagramResource.getInstance(graph);
		ModelingResources MOD = ModelingResources.getInstance(graph);
		StructuralResource2 STR = StructuralResource2.getInstance(graph);
		Resource resource = diagram.getResource();
		if(graph.isInstanceOf(resource, DIA.Diagram)) return graph.getSingleObject(resource, MOD.DiagramToComposite);
		else if (graph.isInstanceOf(resource, STR.Composite)) return resource;
		else throw new DatabaseException("Expected diagram or composite, got " + NameUtils.getSafeName(graph, resource));
	}
	
	@Override
	protected void run(WriteGraph graph, CommandSequenceEnvironment environment) throws DatabaseException {
		
		System.err.println("Merging flags in: " + NameUtils.getSafeName(graph, getComposite(graph)));
    	ArrayList<ArrayList<Resource>> groups = new ArrayList<ArrayList<Resource>>();
    	org.simantics.modeling.flags.MergeFlags.collectFlagGroupsInComposite(graph, getComposite(graph), groups);
        for(ArrayList<Resource> group : groups) {
        	org.simantics.modeling.flags.MergeFlags.merge(graph, group);
        }
        
	}

}