/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class MoveDown implements ActionFactory {

	@Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource selection = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        
                        Layer0 L0 = Layer0.getInstance(g);
                        ScenegraphResources SG = ScenegraphResources.getInstance(g);
                        
                        Resource parent = g.getPossibleObject(selection, L0.PartOf);
                        if (parent == null)
                        	return;
                        
                        Resource list = g.getPossibleObject(parent, SG.Node_children);
                        if (list == null)
                        	return;
                        
                        ListUtils.swapWithNext(g, list, selection);
                    }
                });
            }
        };
    }
}
