/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperimentPath;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scl.runtime.function.FunctionImpl2;

/**
 * f: (ReadGraph, Resource model) -> Variable activeExperiment
 * 
 * @author Tuukka Lehtonen
 */
public class ActiveExperiment extends FunctionImpl2<ReadGraph, Resource, Variable> {

    @Override
    public Variable apply(ReadGraph p0, Resource p1) {
        try {
            ReadGraph graph = (ReadGraph) p0;
            Resource model = (Resource) p1;

            String activeExperimentPath = graph.syncRequest(new PossibleActiveExperimentPath(model));
            if (activeExperimentPath == null)
                return null;

            Variable var = Variables.getPossibleVariable(graph, model);
            if (var == null)
                return null;
            Variable run = var.browsePossible(graph, activeExperimentPath);
            return run;
        } catch (DatabaseException e) {
            Logger.defaultLogError(e);
            return null;
        }
    }

}
