/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.ui.scheme;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.message.AbstractMessageSchemeHandler;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ResourceSchemeHandler extends AbstractMessageSchemeHandler<Resource> {

    public ResourceSchemeHandler() {
        super("resource", Resource.class); //$NON-NLS-1$
    }

    @Override
    public void doPerform(Resource r) {
        Session session = Simantics.peekSession();
        if (session == null) {
            // FIXME: not stdout.
            System.out.println("ResourceSchemeHandler: no session"); //$NON-NLS-1$
            return;
        }

        // Try the doubleClick-extensions
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null)
            return;

        final String perspectiveId = WorkbenchUtils.getCurrentPerspectiveId();

        session.asyncRequest(new ChooseActionRequest(window.getShell(), r, perspectiveId, false, true));
        
    }

}
