/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.constraint.instructions.CombinedInstruction;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class OrInstruction
extends CombinedInstruction {
    public OrInstruction(IInstruction ... instructions) {
        super(instructions);
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        int instructionId = 0;
        while (instructionId < this.instructions.length - 1) {
            Object continuation = this.instructions[instructionId].query(g, bindings);
            if (continuation != IInstruction.FAILURE) {
                return new Continuation(continuation, instructionId);
            }
            ++instructionId;
        }
        return this.instructions[instructionId].query(g, bindings);
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object ret_) throws DatabaseException {
        Continuation ret = (Continuation)ret_;
        int instructionId = ret.instructionId;
        Object continuation = ret.continuation;
        if (continuation != null && (continuation = this.instructions[instructionId].next(g, bindings, continuation)) != IInstruction.FAILURE) {
            ret.continuation = continuation;
            return ret;
        }
        ++instructionId;
        while (instructionId < this.instructions.length - 1) {
            continuation = this.instructions[instructionId].query(g, bindings);
            if (continuation != IInstruction.FAILURE) {
                ret.continuation = continuation;
                ret.instructionId = instructionId;
                return ret;
            }
            ++instructionId;
        }
        return this.instructions[instructionId].query(g, bindings);
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("(    ");
        boolean first = true;
        IInstruction[] iInstructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            IInstruction inst = iInstructionArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(";\n");
                int i = 0;
                while (i < indent + 1) {
                    b.append("     ");
                    ++i;
                }
            }
            inst.toString(b, indent + 1);
            ++n2;
        }
        b.append('\n');
        int i = 0;
        while (i < indent) {
            b.append("     ");
            ++i;
        }
        b.append(")");
    }

    static class Continuation {
        Object continuation;
        int instructionId;

        public Continuation(Object continuation, int instructionId) {
            this.continuation = continuation;
            this.instructionId = instructionId;
        }
    }
}

