package org.simantics.lz4;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

import org.simantics.compressions.CompressionCodec;
import org.simantics.compressions.Compressions;

public class LZ4Codec implements CompressionCodec {
    
    public LZ4Codec() {
    }
    
    @Override
    public int compressBound(int inputSize) {
        return LZ4.compressBound(inputSize);
    }

    @Override
    public int compressBuffer(ByteBuffer input, int inputOffset,
            int length, ByteBuffer output, int outputOffset) {
        return LZ4.compressBuffer(input, inputOffset, length, output, outputOffset);
    }

    @Override
    public int decompressBuffer(ByteBuffer input, int inputOffset,
            int length, ByteBuffer output, int outputOffset, int maxout) {
        return LZ4.decompressBuffer(input, inputOffset, length, output, outputOffset, maxout);
    }

    @Override
    public InputStream read(File file) throws FileNotFoundException {
        return LZ4.read(file);
    }

    @Override
    public OutputStream write(File file) throws FileNotFoundException {
        return LZ4.write(file);
    }

    @Override
    public int compress(byte[] uncompressedData, int srcOff, int srcLength,
            byte[] compressedData, int destOff) {
        return LZ4.getInstance().fastCompressor().compress(uncompressedData, srcOff, srcLength, compressedData, destOff);
    }

    @Override
    public byte[] decompress(byte[] compressedData, int srcOff,
            int uncompressedLength) {
        return LZ4.getInstance().fastDecompressor().decompress(compressedData, srcOff, uncompressedLength);
    }

    @Override
    public String getId() {
        return Compressions.LZ4;
    }

}
