/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.binaryPredicates;

import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.binaryPredicates.BinaryPredicate;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.utils.datastructures.Pair;

public class CompositePredicate
extends BinaryPredicate {
    IBinaryPredicate first;
    IBinaryPredicate second;
    int hasStatementDirection;
    int getStatementsDirection;

    public CompositePredicate(IBinaryPredicate first, IBinaryPredicate second) {
        this.first = first;
        this.second = second;
        this.getStatementsDirection = first.supportsGetStatements() && second.supportsGetObjects() ? 1 : (second.supportsGetStatements() && first.supportsGetSubjects() ? 2 : 0);
        if (first.supportsGetObjects()) {
            this.hasStatementDirection = 1;
        } else if (second.supportsGetSubjects()) {
            this.hasStatementDirection = 2;
        } else {
            throw new IllegalArgumentException("Cannot compose binary predicates such that the first one does not support getObjects and the second one does not support getSubjects.");
        }
    }

    @Override
    public Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException {
        HashSet<Resource> result = new HashSet<Resource>();
        for (Resource r : this.first.getObjects(g, subject)) {
            result.addAll(this.second.getObjects(g, r));
        }
        return result;
    }

    @Override
    public Collection<Pair<Resource, Resource>> getStatements(ReadGraph g) throws DatabaseException {
        HashSet<Pair<Resource, Resource>> result = new HashSet<Pair<Resource, Resource>>();
        if (this.getStatementsDirection == 1) {
            for (Pair<Resource, Resource> p : this.first.getStatements(g)) {
                for (Resource r : this.second.getObjects(g, (Resource)p.second)) {
                    result.add((Pair<Resource, Resource>)new Pair((Object)((Resource)p.first), (Object)r));
                }
            }
        } else if (this.getStatementsDirection == 2) {
            for (Pair<Resource, Resource> p : this.second.getStatements(g)) {
                for (Resource r : this.second.getSubjects(g, (Resource)p.first)) {
                    result.add((Pair<Resource, Resource>)new Pair((Object)r, (Object)((Resource)p.second)));
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    @Override
    public Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
        HashSet<Resource> result = new HashSet<Resource>();
        for (Resource r : this.second.getSubjects(g, object)) {
            result.addAll(this.first.getSubjects(g, r));
        }
        return result;
    }

    @Override
    public boolean has(ReadGraph g, Resource subject, Resource object) throws DatabaseException {
        if (this.hasStatementDirection == 1) {
            for (Resource r : this.first.getObjects(g, subject)) {
                if (!this.second.has(g, r, object)) continue;
                return true;
            }
        } else {
            for (Resource r : this.second.getSubjects(g, object)) {
                if (!this.second.has(g, subject, r)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(WriteGraph g, Resource subject, Resource object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(WriteGraph g, Resource subject, Resource object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAdditions() {
        return false;
    }

    @Override
    public boolean supportsGetObjects() {
        return this.first.supportsGetObjects() && this.second.supportsGetObjects();
    }

    @Override
    public boolean supportsGetStatements() {
        return this.getStatementsDirection != 0;
    }

    @Override
    public boolean supportsGetSubjects() {
        return this.first.supportsGetSubjects() && this.second.supportsGetSubjects();
    }

    @Override
    public boolean supportsRemovals() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositePredicate other = (CompositePredicate)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }
}

