/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.predicates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public class Conjunction extends UnaryPredicate {

	Collection<IUnaryPredicate> predicates;
	IUnaryPredicate support;

	public Conjunction(Collection<IUnaryPredicate> predicates) {
		for(IUnaryPredicate pred : predicates)
			if(pred.supportsUnboundedQuery()) {
				this.support = pred;
				this.predicates = new ArrayList<IUnaryPredicate>(predicates.size()-1);
				for(IUnaryPredicate pred2 : predicates)
					if(pred != pred2)
						this.predicates.add(pred2);
				return;
			}
		this.predicates = predicates;
		this.support = null;
	}
	
	public Conjunction(IUnaryPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

	@Override
	public Collection<Resource> getResources(ReadGraph g) throws DatabaseException {
		Collection<Resource> result = new ArrayList<Resource>();
		ll:	for(Resource r : support.getResources(g)) {			
			for(IUnaryPredicate pred : predicates)
				if(!pred.has(g, r))
					continue ll;
			result.add(r);
		}
		return result;
	}

	@Override
	public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
		for(IUnaryPredicate pred : predicates)
			if(!pred.has(g, resource))
				return false;
		return support == null || support.has(g, resource);
	}

	@Override
	public boolean supportsUnboundedQuery() {		
		return support != null;
	}	
	
	@Override
	public void add(WriteGraph g, Resource r) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void remove(WriteGraph g, Resource r) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean supportsAddition() {
		return false;
	}

	@Override
	public boolean supportsRemoval() {		
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((predicates == null) ? 0 : predicates.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Conjunction other = (Conjunction) obj;
		if (predicates == null) {
			if (other.predicates != null)
				return false;
		} else if (!predicates.equals(other.predicates))
			return false;
		return true;
	}
		
}
