/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.instantiation;

import java.util.ArrayList;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.Literals;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;


public class Instance {
    
    public static class RelatedInstance {
        Resource relation;
        Instance instance;
        int      cardinality;
    }

    public Resource              equals           = null;
    public List<RelatedInstance> relatedInstances = new ArrayList<RelatedInstance>();
    public Object                value            = null;

    public Instance() {
    }
    
    public Instance(Resource equals) {
        this.equals = equals;
    }
    
    public Resource instantiate(WriteGraph graph) throws DatabaseException {
        if(equals != null)
            return equals;
        Resource ret = graph.newResource();        
        for(RelatedInstance instance : relatedInstances)
            for(int i=0;i<instance.cardinality;++i) 
                graph.claim(ret, instance.relation, 
                        instance.instance.instantiate(graph));
        if(value != null)
            graph.claimValue(ret, value);
        return ret;
    }
    
    public Resource instantiateUsing(WriteGraph graph, Resource resource) throws DatabaseException {
        if(equals != null)
            return equals;
        Resource ret = resource;        
        for(RelatedInstance instance : relatedInstances)
            for(int i=0;i<instance.cardinality;++i) 
                graph.claim(ret, instance.relation, 
                        instance.instance.instantiate(graph));     
        if(value != null)
            graph.claimValue(ret, value);
        return ret;
    }   
    
    public void print(StringBuilder builder, int indentation, ReadGraph graph) throws DatabaseException {
        ++ indentation;
        if(equals != null) {
            builder.append(NameUtils.getSafeName(graph, equals));
        }
        else {
            if(value != null) {
                builder.append(Literals.literalToString(value));
                builder.append(" : ");
            }
            else 
                builder.append("* : ");        
//            boolean first = true;            
    
            for(RelatedInstance instance : relatedInstances) {
                builder.append("\n");
                for(int i=0;i<indentation;++i)
                    builder.append("    ");
                builder.append(NameUtils.getSafeName(graph, instance.relation));
                if(instance.cardinality != 1)
                    builder.append("[" + instance.cardinality + "]");
                builder.append(" = ");
                instance.instance.print(builder, indentation, graph);
            }

        }
    }
    
    public String toString(ReadGraph graph) throws DatabaseException {
        StringBuilder builder = new StringBuilder();
        print(builder, 0, graph);
        return builder.toString();
    }
    
}
