/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.RangeHandlerFactory;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.RunnableWithObject;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.ui.AdaptionUtils;

public class RangeComposite
extends Composite
implements Widget {
    private Composite composite;

    public RangeComposite(Composite parent, ISessionContext context, WidgetSupport support, int style) {
        super(parent, style);
        support.register((Widget)this);
        GridLayoutFactory.fillDefaults().spacing(3, 0).margins(3, 0).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        this.composite = this;
    }

    public void setInput(final ISessionContext context, final Object input) {
        RangeHandlerFactory f;
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        final Resource series = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        try {
            f = (RangeHandlerFactory)context.getSession().syncRequest((Read)new Read<RangeHandlerFactory>(){

                public RangeHandlerFactory perform(ReadGraph graph) throws DatabaseException {
                    return (RangeHandlerFactory)graph.adapt(series, RangeHandlerFactory.class);
                }
            });
        }
        catch (DatabaseException databaseException) {
            return;
        }
        final RangeHandlerFactory factory = f;
        context.getSession().asyncRequest(factory.getRequest(series), (Listener)new Listener<LinkedHashMap<String, Resource>>(){

            public void execute(LinkedHashMap<String, Resource> result) {
                if (this.isDisposed()) {
                    return;
                }
                RangeComposite.this.composite.getDisplay().asyncExec((Runnable)new RunnableWithObject(result){

                    public void run() {
                        if ((this).RangeComposite.this.composite == null || (this).RangeComposite.this.composite.isDisposed()) {
                            return;
                        }
                        Control[] controlArray = (this).RangeComposite.this.composite.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control child = controlArray[n2];
                            child.dispose();
                            ++n2;
                        }
                        (this).RangeComposite.this.composite.layout();
                        if (this.getObject() == null) {
                            Label label = new Label((this).RangeComposite.this.composite, 0);
                            label.setText("\u2014");
                            label.setEnabled(false);
                            GridDataFactory.fillDefaults().applyTo((Control)label);
                            (this).RangeComposite.this.composite.layout();
                            return;
                        }
                        WidgetSupportImpl support = new WidgetSupportImpl();
                        LinkedHashMap result = (LinkedHashMap)this.getObject();
                        Iterator iterator = result.keySet().iterator();
                        GridLayout gl = (GridLayout)(this).RangeComposite.this.composite.getLayout();
                        gl.numColumns = result.size();
                        int index = 0;
                        while (iterator.hasNext()) {
                            Object key = iterator.next();
                            Composite c = new Composite((this).RangeComposite.this.composite, 0);
                            GridDataFactory.fillDefaults().applyTo((Control)c);
                            GridLayoutFactory.fillDefaults().applyTo(c);
                            Label label = new Label(c, 0);
                            label.setText((String)key);
                            GridDataFactory.fillDefaults().align(0x1000000, 0x1000008).applyTo((Control)label);
                            TrackedCombo combo = new TrackedCombo(c, (WidgetSupport)support, 8);
                            combo.setItemFactory(factory.getRangeItemFactory(index, (Resource)result.get(key)));
                            combo.setSelectionFactory((ReadFactory)new RangeSelectionFactory(index));
                            combo.addModifyListener((TextModifyListener)new RangeModifyListener(index, result.size()));
                            GridDataFactory.fillDefaults().applyTo((Control)combo.getWidget());
                            ++index;
                        }
                        support.fireInput(context, input);
                        (this).RangeComposite.this.composite.layout();
                        Composite previousParent = (this).RangeComposite.this.composite.getParent();
                        int i = 0;
                        while (i < 7 && previousParent != null) {
                            previousParent.layout();
                            if (previousParent.getParent() instanceof ScrolledComposite) {
                                ScrolledComposite sc = (ScrolledComposite)previousParent.getParent();
                                Point size = previousParent.computeSize(-1, -1);
                                sc.setMinSize(size);
                                break;
                            }
                            previousParent = previousParent.getParent();
                            ++i;
                        }
                    }
                });
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return RangeComposite.this.composite == null || RangeComposite.this.composite.isDisposed();
            }
        });
    }

    protected Resource getIndexRelation(ReadGraph graph) {
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        return jfree.variableFilter;
    }

    private static String getFirstIndex(ReadGraph graph, Resource series, int index) throws DatabaseException {
        Map indexmap;
        RangeHandlerFactory f = (RangeHandlerFactory)graph.adapt(series, RangeHandlerFactory.class);
        LinkedHashMap map = (LinkedHashMap)graph.syncRequest(f.getRequest(series));
        if (map == null) {
            return null;
        }
        Resource enumeration = null;
        Iterator iterator = map.values().iterator();
        int i = 0;
        while (i <= index && iterator.hasNext()) {
            enumeration = (Resource)iterator.next();
            ++i;
        }
        if (enumeration != null && (indexmap = (Map)f.getRangeItemFactory(index, enumeration).perform(graph, null)) != null) {
            return indexmap.values().iterator().next().toString();
        }
        return null;
    }

    private class RangeModifyListener
    extends ComboModifyListenerImpl<Resource> {
        private int index;
        private int size;

        public RangeModifyListener(int index, int size) {
            this.index = index;
            this.size = size;
        }

        public void applyText(WriteGraph graph, Resource series, String text) throws DatabaseException {
            Resource filterRelation = RangeComposite.this.getIndexRelation((ReadGraph)graph);
            String[] filter = (String[])graph.getPossibleRelatedValue(series, filterRelation, (Binding)Bindings.STRING_ARRAY);
            if (filter == null) {
                filter = new String[this.size];
                int i = 0;
                while (i < filter.length) {
                    filter[i] = RangeComposite.getFirstIndex((ReadGraph)graph, series, i);
                    ++i;
                }
            }
            filter[this.index] = text;
            graph.claimLiteral(series, filterRelation, (Object)filter, (Binding)Bindings.STRING_ARRAY);
        }
    }

    private class RangeSelectionFactory
    extends ReadFactoryImpl<Resource, String> {
        int index;

        public RangeSelectionFactory(int index) {
            this.index = index;
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, (Object)this.index, ((Object)((Object)this)).getClass());
        }

        public String perform(ReadGraph graph, Resource series) throws DatabaseException {
            String[] filter = (String[])graph.getPossibleRelatedValue(series, RangeComposite.this.getIndexRelation(graph), (Binding)Bindings.STRING_ARRAY);
            String result = null;
            result = filter == null ? RangeComposite.getFirstIndex(graph, series, this.index) : (filter.length < this.index ? RangeComposite.getFirstIndex(graph, series, this.index) : filter[this.index]);
            return result;
        }
    }
}

