/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.JFreeChart;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.operation.Layer0X;
import org.simantics.sysdyn.JFreeChartResource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ChartUtils {
    public static final String emptyVariableName = "<Write variable name>";

    public static Resource createNumberRangeAxis(WriteGraph graph, Resource plot) throws DatabaseException {
        Resource axis = null;
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (plot != null) {
            axis = GraphUtils.create2((WriteGraph)graph, (Resource)jfree.NumberAxis, (Object[])new Object[]{l0.HasName, "NumberAxis" + UUID.randomUUID().toString(), l0.HasLabel, NameUtils.findFreshLabel((ReadGraph)graph, (String)"Y-axis", (Resource)plot), jfree.Plot_rangeAxis_Inverse, plot, l0.PartOf, plot});
            Resource axisList = graph.getPossibleObject(plot, jfree.Plot_rangeAxisList);
            ArrayList<Resource> list = new ArrayList<Resource>();
            list.add(axis);
            if (axisList == null) {
                axisList = ListUtils.create((WriteGraph)graph, list);
                graph.claim(plot, jfree.Plot_rangeAxisList, axisList);
            } else {
                ListUtils.insertBack((WriteGraph)graph, (Resource)axisList, list);
            }
        }
        return axis;
    }

    public static Resource createXYDataset(WriteGraph graph, Resource plot, Resource domainAxis, Resource rangeAxis) throws DatabaseException {
        if (plot == null || domainAxis == null || rangeAxis == null) {
            return null;
        }
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource dataset = GraphUtils.create2((WriteGraph)graph, (Resource)jfree.XYDataset, (Object[])new Object[]{l0.HasName, "XYDataset" + UUID.randomUUID().toString(), jfree.Dataset_mapToDomainAxis, domainAxis, jfree.Dataset_mapToRangeAxis, rangeAxis, jfree.Dataset_renderer, GraphUtils.create2((WriteGraph)graph, (Resource)jfree.XYLineRenderer, (Object[])new Object[0]), l0.PartOf, plot});
        return dataset;
    }

    public static Resource createSeries(WriteGraph graph, Resource dataset, String rvi) throws DatabaseException {
        if (dataset == null) {
            return null;
        }
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource series = GraphUtils.create2((WriteGraph)graph, (Resource)jfree.Series, (Object[])new Object[]{l0.HasName, "Series" + UUID.randomUUID().toString(), jfree.variableRVI, rvi == null ? " <Write variable name>" : rvi, l0.PartOf, dataset});
        Resource seriesList = graph.getPossibleObject(dataset, jfree.Dataset_seriesList);
        ArrayList<Resource> list = new ArrayList<Resource>();
        list.add(series);
        if (seriesList == null) {
            seriesList = ListUtils.create((WriteGraph)graph, list);
            graph.claim(dataset, jfree.Dataset_seriesList, seriesList);
        } else {
            ListUtils.insertBack((WriteGraph)graph, (Resource)seriesList, list);
        }
        return series;
    }

    public static String getCurrentRealizationURI(ReadGraph graph, Resource chartComponent) throws DatabaseException {
        Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(chartComponent));
        if (model == null) {
            return null;
        }
        String realizationURI = null;
        Resource realization = (Resource)graph.syncRequest((Read)new PossibleActiveExperiment(model));
        if (realization == null) {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            realization = graph.getPossibleObject(model, L0X.HasBaseRealization);
        }
        if (realization != null) {
            realizationURI = graph.getURI(realization);
        }
        return realizationURI;
    }

    public static void writeSVG(JFreeChart chart, Rectangle2D bounds, Writer out) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.setSVGCanvasSize(new Dimension((int)bounds.getWidth(), (int)bounds.getHeight()));
        chart.draw((Graphics2D)svgGenerator, bounds);
        svgGenerator.stream(out, false);
    }

    public static void writeSVG(JFreeChart chart, Rectangle2D bounds, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
        ChartUtils.writeSVG(chart, bounds, out);
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }
}

