/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.util.Collection;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.plot.Plot;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.IAxis;
import org.simantics.jfreechart.chart.IDataset;
import org.simantics.jfreechart.chart.IPlot;
import org.simantics.jfreechart.chart.PlotProperties;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;

public abstract class AbstractPlot
implements IPlot {
    protected Resource resource;
    protected Plot plot;
    protected PlotProperties currentProperties;
    protected PlotPropertyListener listener;
    protected JFreeChart jfreechart;

    public AbstractPlot(ReadGraph graph, Resource resource) {
        this.resource = resource;
    }

    @Override
    public void dispose() {
        if (this.currentProperties != null) {
            for (IAxis axis : this.currentProperties.ranges) {
                axis.dispose();
            }
            for (IAxis axis : this.currentProperties.domains) {
                axis.dispose();
            }
            for (IDataset dataset : this.currentProperties.datasets) {
                dataset.dispose();
            }
            this.currentProperties = null;
        }
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        this.jfreechart = null;
        this.plot = null;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public void setJFreeChart(JFreeChart jfreechart) {
        this.jfreechart = jfreechart;
    }

    @Override
    public JFreeChart getJfreechart() {
        return this.jfreechart;
    }

    @Override
    public PlotProperties getPlotProperties() {
        return this.currentProperties;
    }

    protected abstract Plot newPlot();

    protected void setPlotProperties(PlotProperties properties) {
        if (this.currentProperties != null) {
            for (IAxis axis : this.currentProperties.ranges) {
                if (properties.ranges.contains(axis)) continue;
                axis.dispose();
            }
            for (IAxis axis : this.currentProperties.domains) {
                if (properties.domains.contains(axis)) continue;
                axis.dispose();
            }
            for (IDataset dataset : this.currentProperties.datasets) {
                if (properties.datasets.contains(dataset)) continue;
                dataset.dispose();
            }
        }
        this.currentProperties = properties;
    }

    protected abstract void getOtherProperties(ReadGraph var1, PlotProperties var2) throws DatabaseException;

    @Override
    public Plot getPlot() {
        if (this.plot == null) {
            this.plot = this.newPlot();
        }
        if (this.listener == null || this.listener.isDisposed()) {
            this.listener = new PlotPropertyListener();
            Simantics.getSession().asyncRequest((Read)new PlotPropertyQuery(), (Listener)this.listener);
        }
        return this.plot;
    }

    protected IDataset getDataset(ReadGraph graph, Resource datasetResource) throws DatabaseException {
        return (IDataset)graph.adapt(datasetResource, IDataset.class);
    }

    @Override
    public void configurePlot(PlotProperties properties) {
    }

    protected class PlotPropertyListener
    implements Listener<PlotProperties> {
        private boolean disposed = false;

        public void dispose() {
            this.disposed = true;
        }

        public void execute(final PlotProperties result) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractPlot.this.setPlotProperties(result);
                    AbstractPlot.this.configurePlot(result);
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    protected class PlotPropertyQuery
    implements Read<PlotProperties> {
        public PlotProperties perform(ReadGraph graph) throws DatabaseException {
            IAxis axis;
            PlotProperties properties = new PlotProperties();
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            HashMap<Resource, IAxis> axisMap = new HashMap<Resource, IAxis>();
            Resource rangeList = graph.getPossibleObject(AbstractPlot.this.resource, jfree.Plot_rangeAxisList);
            if (rangeList != null) {
                for (Resource axisResource : ListUtils.toList((ReadGraph)graph, (Resource)rangeList)) {
                    axis = (IAxis)graph.adapt(axisResource, IAxis.class);
                    if (!(axis.getAxis() instanceof Axis)) continue;
                    properties.ranges.add(axis);
                    axisMap.put(axisResource, axis);
                }
            }
            for (Resource axisResource : (Collection)graph.syncRequest((Read)new ObjectsWithType(AbstractPlot.this.resource, jfree.Plot_domainAxis, jfree.Axis))) {
                axis = (IAxis)graph.adapt(axisResource, IAxis.class);
                if (!(axis.getAxis() instanceof Axis)) continue;
                properties.domains.add(axis);
                axisMap.put(axisResource, axis);
            }
            for (Resource datasetResource : (Collection)graph.syncRequest((Read)new ObjectsWithType(AbstractPlot.this.resource, l0.ConsistsOf, jfree.Dataset))) {
                IAxis axis2;
                IDataset dataset = AbstractPlot.this.getDataset(graph, datasetResource);
                if (dataset == null) continue;
                properties.datasets.add(dataset);
                Resource axisResource = graph.getPossibleObject(datasetResource, jfree.Dataset_mapToRangeAxis);
                if (axisMap.containsKey(axisResource)) {
                    axis2 = (IAxis)axisMap.get(axisResource);
                    properties.rangeMappings.put(dataset, axis2);
                }
                if (!axisMap.containsKey(axisResource = graph.getPossibleObject(datasetResource, jfree.Dataset_mapToDomainAxis))) continue;
                axis2 = (IAxis)axisMap.get(axisResource);
                properties.domainMappings.put(dataset, axis2);
            }
            AbstractPlot.this.getOtherProperties(graph, properties);
            return properties;
        }
    }
}

