/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.ge;

import java.util.Collections;
import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.jfreechart.chart.properties.IAllVariablesOfModel;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Label rule for dataset series
 * @author Teemu Lempinen
 *
 */
public class SeriesLabelRule implements LabelRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    /**
     * Options:
     * 1. Label
     * 2. Variable rvi
     * 3. Default
     */
    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
        Layer0 l0 = Layer0.getInstance(graph);
        Resource resource = (Resource)content;
        String label = graph.getPossibleRelatedValue(resource, l0.HasLabel, Bindings.STRING);
        if(label == null || label.isEmpty()) {
        	IAllVariablesOfModel vom = graph.adapt(resource, IAllVariablesOfModel.class);
        	
        	String rvi = graph.getPossibleRelatedValue(resource, jfree.variableRVI);
        	if (rvi != null) {
        		label =vom.getVariablesLabel(graph, rvi);
        		if (label == null)
        			label = rvi;
        	} else
                label = "Set variable";
        }
        return Collections.singletonMap(ColumnKeys.SINGLE, label);
    }

}
