/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

/**
 * Renderer representing jfree chart renderer for xy areas
 * @author Teemu Lempinen
 *
 */
public class XYAreaRenderer extends AbstractRenderer {

    private org.jfree.chart.renderer.xy.XYAreaRenderer renderer;
    
    public XYAreaRenderer(ReadGraph graph, Resource resource) {
        super(graph, resource);
    }

    @Override
    public org.jfree.chart.renderer.AbstractRenderer getRenderer() {
        if(renderer == null) {
            renderer = new org.jfree.chart.renderer.xy.XYAreaRenderer();
            renderer.setDefaultToolTipGenerator(new StandardXYToolTipGenerator());
        }
        return renderer;
    }

}