/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * Container for a chart panel element. Needed for
 * moving chart panel elements around using setParent()
 * @author Teemu Lempinen
 *
 */
public class ElementContainer extends Composite {

    @Override
    public Object getLayoutData () {
        Control[] children = getChildren();
        if(children.length == 1) {
            if(children[0] instanceof ChartPanelElement) {
                ChartPanelElement element = (ChartPanelElement)children[0];
                return element.getLayoutData();
            }
        }
        return super.getLayoutData();
    }
    
    public ElementContainer(Composite parent, int style) {
        super(parent, style);
    }

}
