/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.image.ui.editor;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.request.Read;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;

public class ImageEditor
extends ResourceEditorPart {
    public static final String EDITOR_ID = "org.simantics.wiki.ui.image.editor";
    protected boolean disposed = false;
    protected Image image;
    protected SVGDiagram svgDiagram;
    private ResourceManager resourceManager;
    private Canvas canvas;
    private double zoomLevel = 1.0;
    private Point2D previousTranslate = new Point2D.Double();
    private Point2D translate = new Point2D.Double();
    private boolean zoomToFit = false;
    private SVGUniverse svgUniverse = new SVGUniverse();
    ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.extractInputResource());

    static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[4];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return this.INPUT_VALIDATOR;
    }

    public void createPartControl(final Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.canvas = new Canvas(parent, 0x20000000);
        this.canvas.setBackground(this.resourceManager.createColor(new RGB(255, 255, 255)));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.canvas);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (ImageEditor.this.svgDiagram != null) {
                    Rectangle2D r = ImageEditor.this.svgDiagram.getViewRect();
                    if (r.isEmpty()) {
                        return;
                    }
                    AffineTransform tr = AffineTransform.getScaleInstance(ImageEditor.this.zoomLevel, ImageEditor.this.zoomLevel);
                    tr.translate(ImageEditor.this.translate.getX(), ImageEditor.this.translate.getY());
                    try {
                        BufferedImage bi = ScenegraphUtils.paintSVG((SVGDiagram)ImageEditor.this.svgDiagram, (AffineTransform)tr, (float)0.0f);
                        Image img = new Image((Device)parent.getDisplay(), ImageEditor.convertToSWT(bi));
                        this.drawImage(event.gc, img, false);
                        img.dispose();
                    }
                    catch (SVGException sVGException) {}
                } else if (ImageEditor.this.image != null) {
                    this.drawImage(event.gc, ImageEditor.this.image, true);
                }
            }

            private void drawImage(GC gc, Image image, boolean fitToCanvas) {
                boolean fitsCanvas;
                Rectangle r = image.getBounds();
                if (r.isEmpty()) {
                    return;
                }
                Point destSize = ImageEditor.this.canvas.getSize();
                int xSpace = destSize.x - r.width;
                int ySpace = destSize.y - r.height;
                boolean fitsX = xSpace >= 0;
                boolean fitsY = ySpace >= 0;
                boolean bl = fitsCanvas = fitsX && fitsY;
                if (!fitsCanvas && fitToCanvas || ImageEditor.this.zoomToFit) {
                    gc.setAntialias(1);
                    int leftMargin = 0;
                    int topMargin = 0;
                    if (xSpace > ySpace) {
                        double yr = (double)destSize.y / (double)r.height;
                        double xo = (int)((double)r.width * yr);
                        leftMargin = (int)Math.round(((double)(destSize.x - r.width) + ((double)r.width - xo)) * 0.5);
                        gc.drawImage(image, 0, 0, r.width, r.height, leftMargin, topMargin, (int)xo, destSize.y);
                    } else {
                        double xr = (double)destSize.x / (double)r.width;
                        double yo = (int)((double)r.height * xr);
                        topMargin = (int)Math.round(((double)(destSize.y - r.height) + ((double)r.height - yo)) * 0.5);
                        gc.drawImage(image, 0, 0, r.width, r.height, leftMargin, topMargin, destSize.x, (int)yo);
                    }
                } else if (!fitsCanvas) {
                    int srcX = fitsX ? 0 : (int)Math.round((double)(-xSpace) * 0.5);
                    int srcY = fitsY ? 0 : (int)Math.round((double)(-ySpace) * 0.5);
                    int srcW = fitsX ? r.width : r.width + xSpace;
                    int srcH = fitsY ? r.height : r.height + ySpace;
                    int destX = fitsX ? (int)Math.round((double)xSpace * 0.5) : 0;
                    int destY = fitsY ? (int)Math.round((double)ySpace * 0.5) : 0;
                    int destW = fitsX ? r.width : destSize.x;
                    int destH = fitsY ? r.height : destSize.y;
                    gc.drawImage(image, srcX, srcY, srcW, srcH, destX, destY, destW, destH);
                } else {
                    int leftMargin = (int)Math.round((double)(destSize.x - r.width) * 0.5);
                    int topMargin = (int)Math.round((double)(destSize.y - r.height) * 0.5);
                    gc.drawImage(image, 0, 0, r.width, r.height, leftMargin, topMargin, r.width, r.height);
                }
            }
        });
        this.canvas.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ImageEditor.this.zoomToFit ^= true;
                ImageEditor.this.canvas.redraw();
            }
        });
        Listener listener = new Listener(){
            boolean pan = false;
            Point panStart = new Point(0, 0);

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 4: {
                        if (e.button != 3) break;
                        this.pan = false;
                        ImageEditor.this.previousTranslate.setLocation(ImageEditor.this.translate);
                        break;
                    }
                    case 3: {
                        if (e.button != 3) break;
                        this.panStart.x = e.x;
                        this.panStart.y = e.y;
                        this.pan = true;
                        ImageEditor.this.previousTranslate.setLocation(ImageEditor.this.translate);
                        break;
                    }
                    case 5: {
                        if (!this.pan) break;
                        int dx = e.x - this.panStart.x;
                        int dy = e.y - this.panStart.y;
                        ImageEditor.this.translate.setLocation(ImageEditor.this.previousTranslate.getX() + (double)dx / ImageEditor.this.zoomLevel, ImageEditor.this.previousTranslate.getY() + (double)dy / ImageEditor.this.zoomLevel);
                        ImageEditor.this.canvas.redraw();
                        break;
                    }
                    case 37: {
                        double scroll = Math.min(0.9, (double)(-e.count) / 20.0);
                        double z = 1.0 - scroll;
                        ImageEditor.this.zoomLevel = this.limitScaleFactor(ImageEditor.this.zoomLevel, z);
                        ImageEditor.this.canvas.redraw();
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private double limitScaleFactor(double zoomLevel, double scaleFactor) {
                double inLimit = 200.0;
                double outLimit = 10.0;
                AffineTransform view = AffineTransform.getScaleInstance(zoomLevel, zoomLevel);
                double currentScale = GeometryUtils.getScale((AffineTransform)view) * 100.0;
                double newScale = currentScale * scaleFactor;
                if (newScale > currentScale && newScale > inLimit) {
                    if (!(currentScale < inLimit)) return inLimit / 100.0;
                    scaleFactor = inLimit / currentScale;
                    return zoomLevel * scaleFactor;
                } else {
                    if (!(newScale < currentScale) || !(newScale < outLimit)) return zoomLevel * scaleFactor;
                    if (!(currentScale > outLimit)) return outLimit / 100.0;
                    scaleFactor = outLimit / currentScale;
                }
                return zoomLevel * scaleFactor;
            }
        };
        this.canvas.addListener(4, listener);
        this.canvas.addListener(3, listener);
        this.canvas.addListener(5, listener);
        this.canvas.addListener(37, listener);
        this.activateValidation();
        this.loadAndTrackInput();
    }

    private void loadAndTrackInput() {
        final Resource input = this.getInputResource();
        Simantics.getSession().asyncRequest((Read)new ResourceRead<Object>(input){

            public Object perform(ReadGraph graph) throws DatabaseException {
                ImageResource img = ImageResource.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(input, img.SvgImage)) {
                    String text = (String)graph.getPossibleValue(input, (Binding)Bindings.STRING);
                    return text;
                }
                if (graph.isInstanceOf(input, img.Image)) {
                    byte[] data = (byte[])graph.getPossibleValue(input, (Binding)Bindings.BYTE_ARRAY);
                    return data;
                }
                return null;
            }
        }, (org.simantics.db.procedure.Listener)new org.simantics.db.procedure.Listener<Object>(){

            public void execute(Object result) {
                Display display;
                if (result instanceof String) {
                    try {
                        ImageEditor.this.svgDiagram = ScenegraphUtils.loadSVGDiagram((SVGUniverse)ImageEditor.this.svgUniverse, (String)((String)result));
                        this.scheduleRedraw();
                    }
                    catch (SVGException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                } else if (result instanceof byte[] && !(display = ImageEditor.this.canvas.getDisplay()).isDisposed()) {
                    try {
                        ImageEditor.this.image = new Image((Device)ImageEditor.this.canvas.getDisplay(), (InputStream)new ByteArrayInputStream((byte[])result));
                        this.scheduleRedraw();
                    }
                    catch (SWTException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                    catch (SWTError e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
            }

            private void scheduleRedraw() {
                Display d = ImageEditor.this.canvas.getDisplay();
                if (!d.isDisposed()) {
                    d.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).ImageEditor.this.canvas.isDisposed()) {
                                (this).ImageEditor.this.canvas.redraw();
                            }
                        }
                    });
                }
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }

            public boolean isDisposed() {
                return ImageEditor.this.disposed;
            }
        });
    }

    public void dispose() {
        this.disposed = true;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.svgUniverse.clear();
    }

    public void setFocus() {
        if (this.canvas != null) {
            this.canvas.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

