package org.simantics.history.csv;


public enum DecimalSeparator {
	DOT("Dot (.)","."),COMMA("Comma (,)",",");
	public String label;
	public String preference;
	DecimalSeparator(String label, String preference) {
		this.label = label;
		this.preference = preference;
	}
	public static DecimalSeparator fromIndex(int index) {
		return values()[index];
	}
	public String toPreference() {
		return preference;
	}
	public static DecimalSeparator fromPreference(String preference) {
		for(DecimalSeparator s : values()) {
			if(s.preference.equals(preference)) return s;
		}
		return DOT;
	}
	public static DecimalSeparator fromChar(char c) {
		String preference = "" + c;
		for(DecimalSeparator s : values()) {
			if(s.preference.equals(preference)) return s;
		}
		return DOT;
	}
}