/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.drawable;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Graphs;
import org.simantics.graphviz.IGraphPart;
import org.simantics.graphviz.Identifiable;
import org.simantics.graphviz.continuation.Computation;
import org.simantics.graphviz.continuation.Continuation;
import org.simantics.graphviz.drawable.Drawable;
import org.simantics.graphviz.internal.xdot.DrawCommand;
import org.simantics.graphviz.internal.xdot.DrawCommandParser;
import org.simantics.graphviz.internal.xdot.ShapeCommand;

public class GraphDrawable2
implements Drawable {
    private static String DEFAULT_ALGORITHM = "dot";
    Collection<DrawCommand> commands;
    Map<IGraphPart, Collection<DrawCommand>> partCommands;
    Map<IGraphPart, Rectangle2D> partBounds;
    Rectangle2D bounds;

    public GraphDrawable2(Graph graph, String algorithm) {
        try {
            this.setGraph(graph, algorithm).get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GraphDrawable2(Graph graph) {
        this.setGraph(graph);
    }

    public GraphDrawable2() {
        this.commands = new ArrayList<DrawCommand>();
        this.partCommands = new HashMap<IGraphPart, Collection<DrawCommand>>();
        this.partBounds = new HashMap<IGraphPart, Rectangle2D>();
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
    }

    public void setGraph(Graph graph) {
        try {
            this.setGraph(graph, DEFAULT_ALGORITHM).get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized Computation<Graph> setGraph(final Graph graph, String algorithm) {
        Computation<Graph> computation = Graphs.createXDot(graph, algorithm);
        computation.addContinuation(new Continuation<Graph>(){

            @Override
            public void succeeded(Graph xgraph) {
                GraphDrawable2.this.commands = new ArrayList<DrawCommand>();
                GraphDrawable2.this.partCommands = new HashMap<IGraphPart, Collection<DrawCommand>>();
                GraphDrawable2.this.partBounds = new HashMap<IGraphPart, Rectangle2D>();
                DrawCommandParser.parse(xgraph, GraphDrawable2.this.commands, GraphDrawable2.this.partCommands);
                GraphDrawable2.this.readBoundingBox(xgraph);
                GraphDrawable2.this.updatePartBoundingBoxes(graph, xgraph);
            }

            @Override
            public void failed(Exception exception) {
            }
        });
        return computation;
    }

    private void readBoundingBox(Graph graph) {
        String[] parts = graph.get("bb").split(",");
        double minX = Double.parseDouble(parts[0]);
        double maxY = -Double.parseDouble(parts[1]);
        double maxX = Double.parseDouble(parts[2]);
        double minY = -Double.parseDouble(parts[3]);
        this.bounds = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    private void updatePartBoundingBoxes(Graph graph, Graph xgraph) {
        HashMap<IGraphPart, IGraphPart> partMap = new HashMap<IGraphPart, IGraphPart>();
        for (IGraphPart xPart : xgraph.getParts()) {
            if (xPart instanceof Identifiable) {
                String xID = ((Identifiable)((Object)xPart)).getId();
                for (IGraphPart gPart : graph.getParts()) {
                    String gID;
                    if (!(gPart instanceof Identifiable) || !xID.equals(gID = ((Identifiable)((Object)gPart)).getId())) continue;
                    partMap.put(xPart, gPart);
                }
                continue;
            }
            if (!(xPart instanceof Edge)) continue;
            String xHeadId = ((Edge)xPart).getHead().getId();
            String xTailId = ((Edge)xPart).getTail().getId();
            for (IGraphPart gPart : graph.getParts()) {
                if (!(gPart instanceof Edge)) continue;
                String gHeadId = ((Edge)gPart).getHead().getId();
                String gTailId = ((Edge)gPart).getTail().getId();
                if (!xHeadId.equals(gHeadId) || !xTailId.equals(gTailId)) continue;
                partMap.put(xPart, gPart);
            }
        }
        for (IGraphPart part : this.partCommands.keySet()) {
            Collection<DrawCommand> pCommands = this.partCommands.get(part);
            Rectangle2D r = null;
            for (DrawCommand c : pCommands) {
                if (!(c instanceof ShapeCommand)) continue;
                Shape s = ((ShapeCommand)c).getShape();
                if (r == null) {
                    r = s.getBounds2D();
                    continue;
                }
                r.add(s.getBounds2D());
            }
            if (r == null) continue;
            this.partBounds.put((IGraphPart)partMap.get(part), r);
        }
    }

    @Override
    public synchronized Rectangle2D getBounds() {
        return this.bounds;
    }

    public synchronized Rectangle2D getBounds(IGraphPart part) {
        return this.partBounds.get(part);
    }

    public synchronized Collection<IGraphPart> pick(Point2D point) {
        ArrayList<IGraphPart> picked = new ArrayList<IGraphPart>();
        for (IGraphPart part : this.partBounds.keySet()) {
            Rectangle2D r = this.partBounds.get(part);
            if (!r.contains(point)) continue;
            picked.add(part);
        }
        return picked;
    }

    @Override
    public synchronized void draw(Graphics2D g, Rectangle2D area) {
        for (DrawCommand command : this.commands) {
            command.draw(g);
        }
    }
}

