/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz;

import java.io.PrintStream;
import java.util.HashSet;
import org.simantics.graphviz.AbstractGraphPart;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.Identifiable;

public class Edge
extends AbstractGraphPart {
    Identifiable tail;
    Identifiable head;

    public Edge(IGraph graph, Identifiable tail, Identifiable head) {
        super(graph);
        this.tail = tail;
        this.head = head;
    }

    private static IGraph chooseParentGraph(IGraph a, IGraph b) {
        if (a == b) {
            return a;
        }
        HashSet<IGraph> graphs = new HashSet<IGraph>();
        while (true) {
            graphs.add(a);
            if (!(a instanceof Identifiable)) break;
            a = ((Identifiable)((Object)a)).getParent();
        }
        while (true) {
            if (graphs.contains(b)) {
                return b;
            }
            if (!(b instanceof Identifiable)) break;
            b = ((Identifiable)((Object)b)).getParent();
        }
        throw new IllegalArgumentException("Tried to connect nodes that do not belong to the same graph.");
    }

    public Edge(Identifiable tail, Identifiable head) {
        this(Edge.chooseParentGraph(tail.getParent(), head.getParent()), tail, head);
    }

    public void setLabel(String label) {
        this.set("label", label);
    }

    public void setHeadLabel(String label) {
        this.set("headlabel", label);
    }

    public void setTailLabel(String label) {
        this.set("taillabel", label);
    }

    public void setDir(String label) {
        this.set("dir", label);
    }

    public void setStyle(String style) {
        this.set("style", style);
    }

    public void setConstraint(boolean constraint) {
        this.set("constraint", Boolean.toString(constraint));
    }

    public void setColor(String color) {
        this.set("color", color);
    }

    public void setFontColor(String color) {
        this.set("fontcolor", color);
    }

    public void setArrowhead(String arrowName) {
        this.set("arrowhead", arrowName);
    }

    public void setArrowtail(String arrowName) {
        this.set("arrowtail", arrowName);
    }

    public void setArrowsize(double arrowSize) {
        this.set("arrowsize", Double.toString(arrowSize));
    }

    public Identifiable getTail() {
        return this.tail;
    }

    public Identifiable getHead() {
        return this.head;
    }

    @Override
    public void write(PrintStream s) {
        s.print(this.tail.getId());
        s.print(" -> ");
        s.print(this.head.getId());
        this.writeAttributes(s);
    }
}

