package org.simantics.graphfile.ui.editor;

import java.util.function.Supplier;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;

/**
 * @author Antti Villberg
 */
public class PlainTextEditor extends TextEditor {

    boolean isDisposed = false;

    ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR =
            Combinators.compose(
                    InputValidationCombinators.hasURI(),
                    InputValidationCombinators.extractInputResource()
            );

    ResourceEditorSupport support;

    public PlainTextEditor() {
        super();
        setDocumentProvider(new PlainTextEditorDocumentProvider());
        //setSourceViewerConfiguration(new QueueTextEditorViewerConfiguration(new QueueTextEditorColorManager()));
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);

        support = new ResourceEditorSupport(this, INPUT_VALIDATOR);
        support.activateValidation();
        try {
            getResourceEditorInput().init(null);
        } catch (DatabaseException e) {
            throw new PartInitException("Failed to initialize " + input, e);
        }
    }

    protected IResourceEditorInput getResourceEditorInput() {
        return (IResourceEditorInput) getEditorInput();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        updatePartName();
    }

    private void updatePartName() {
        setPartName(getEditorInput().getName());

        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = () -> isDisposed;
            session.asyncRequest(
                    new TitleRequest(null, getResourceEditorInput()),
                    new TitleUpdater(getSite().getShell().getDisplay(), this::setPartName, disposedCallback));
            session.asyncRequest(
                    new ToolTipRequest(getSite().getId(), getResourceEditorInput()),
                    new TitleUpdater(getSite().getShell().getDisplay(), this::setTitleToolTip, disposedCallback));
        }

    }

    @Override
    public void dispose() {
        isDisposed = true;
        if (support != null) {
            support.dispose();
            support = null;
        }
        super.dispose();
    }

}
