package org.simantics.graphfile.ui.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class GraphFileUIResource {
    
    public final Resource BrowseContext;
    public final Resource BrowseContext_Actions;
    public final Resource BrowseContext_Actions_ExportDocumentFolder;
    public final Resource BrowseContext_Actions_ExportFileDocument;
    public final Resource BrowseContext_Actions_ImportDocumentFolder;
    public final Resource BrowseContext_Actions_ImportFileDocument;
    public final Resource BrowseContext_Actions_NewDocumentFolder;
    public final Resource BrowseContext_Actions_NewFileDocument;
    public final Resource ModelingActionContext;
    public final Resource ModelingBrowseContext;
        
    public static class URIs {
        public static final String BrowseContext = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext";
        public static final String BrowseContext_Actions = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext/Actions";
        public static final String BrowseContext_Actions_ExportDocumentFolder = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext/Actions/ExportDocumentFolder";
        public static final String BrowseContext_Actions_ExportFileDocument = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext/Actions/ExportFileDocument";
        public static final String BrowseContext_Actions_ImportDocumentFolder = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext/Actions/ImportDocumentFolder";
        public static final String BrowseContext_Actions_ImportFileDocument = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext/Actions/ImportFileDocument";
        public static final String BrowseContext_Actions_NewDocumentFolder = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext/Actions/NewDocumentFolder";
        public static final String BrowseContext_Actions_NewFileDocument = "http://www.simantics.org/GraphFileUI-1.0/BrowseContext/Actions/NewFileDocument";
        public static final String ModelingActionContext = "http://www.simantics.org/GraphFileUI-1.0/ModelingActionContext";
        public static final String ModelingBrowseContext = "http://www.simantics.org/GraphFileUI-1.0/ModelingBrowseContext";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public GraphFileUIResource(ReadGraph graph) {
        BrowseContext = getResourceOrNull(graph, URIs.BrowseContext);
        BrowseContext_Actions = getResourceOrNull(graph, URIs.BrowseContext_Actions);
        BrowseContext_Actions_ExportDocumentFolder = getResourceOrNull(graph, URIs.BrowseContext_Actions_ExportDocumentFolder);
        BrowseContext_Actions_ExportFileDocument = getResourceOrNull(graph, URIs.BrowseContext_Actions_ExportFileDocument);
        BrowseContext_Actions_ImportDocumentFolder = getResourceOrNull(graph, URIs.BrowseContext_Actions_ImportDocumentFolder);
        BrowseContext_Actions_ImportFileDocument = getResourceOrNull(graph, URIs.BrowseContext_Actions_ImportFileDocument);
        BrowseContext_Actions_NewDocumentFolder = getResourceOrNull(graph, URIs.BrowseContext_Actions_NewDocumentFolder);
        BrowseContext_Actions_NewFileDocument = getResourceOrNull(graph, URIs.BrowseContext_Actions_NewFileDocument);
        ModelingActionContext = getResourceOrNull(graph, URIs.ModelingActionContext);
        ModelingBrowseContext = getResourceOrNull(graph, URIs.ModelingBrowseContext);
    }
    
    public static GraphFileUIResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        GraphFileUIResource ret = session.peekService(GraphFileUIResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new GraphFileUIResource(qc.getIndependentGraph(graph));
            session.registerService(GraphFileUIResource.class, ret);
        }
        return ret;
    }
    
    public static GraphFileUIResource getInstance(RequestProcessor session) throws DatabaseException {
        GraphFileUIResource ret = session.peekService(GraphFileUIResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<GraphFileUIResource>() {
                public GraphFileUIResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new GraphFileUIResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(GraphFileUIResource.class, ret);
        }
        return ret;
    }
    
}

