/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphfile.hack;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graphfile.Activator;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;

/**
 * This is a wrapper for Graph based files. 
 * 
 * DO NOT USE this with File(Input/Output)Stream. 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class GraphJavaFile extends File {
	
	private static final long serialVersionUID = 8213749101292672725L;
	private Session session;
	private Resource fileResource;
	
	public GraphJavaFile(Resource fileResource) {
		super("");
		this.fileResource = fileResource;
		this.session = Simantics.getSession();
	}
	
	private byte[] getResourceData(ReadGraph graph) throws DatabaseException {
		GraphFileResource gf = GraphFileResource.getInstance(graph);
		return graph.getRelatedValue(fileResource, gf.HasFiledata);
	}
	
	private byte[] getResourceData() throws DatabaseException {
		return Simantics.getSession().syncRequest(new Read<byte[]>() {
			@Override
			public byte[] perform(ReadGraph graph) throws DatabaseException {
				return getResourceData(graph);
			}
		});
	}
	
	@Override
	public boolean canExecute() {
		return false;
	}
	
	@Override
	public boolean canRead() {
		return false;
	}
	
	@Override
	public boolean canWrite() {
		return false;
	}
	
	@Override
	public boolean createNewFile() throws IOException {
		return false;
	}
	
	@Override
	public boolean delete() {
		try {
			session.syncRequest(new WriteRequest() {
				
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					graph.deny(fileResource);
				}
			});
			return true;
		} catch (DatabaseException e) {
			Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to delete file resource " + fileResource, e));
			return false;
		}
	}
	
	@Override
	public void deleteOnExit() {
		
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (!obj.getClass().equals(getClass()))
			return false;
		GraphJavaFile other = (GraphJavaFile)obj;
		return fileResource.equals(other.fileResource);
	}
	
	@Override
	public File getAbsoluteFile() {
		return this;
	}
	
	@Override
	public boolean exists() {
		try {
			return session.syncRequest(new Read<Boolean>() {
				@Override
				public Boolean perform(ReadGraph graph) throws DatabaseException {
					GraphFileResource gf = GraphFileResource.getInstance(graph);
					return graph.getPossibleRelatedValue(fileResource, gf.HasFiledata) != null;
				}
			});
		} catch (DatabaseException e) {
			Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "exists check failed for file resource " + fileResource, e));
			return false;
		}
	}
	
	@Override
	public String getAbsolutePath() {
		return null;
	}
	
	@Override
	public File getCanonicalFile() throws IOException {
		return this;
	}
	
	@Override
	public String getCanonicalPath() throws IOException {
		return null;
	}
	
	@Override
	public long getFreeSpace() {
		return 0;
	}
	
	@Override
	public String getName() {
		try {
			return Simantics.getSession().syncRequest(new Read<String>() {
				@Override
				public String perform(ReadGraph graph) throws DatabaseException {
					Layer0 l0 = Layer0.getInstance(graph);
					return graph.getRelatedValue(fileResource, l0.HasName);
				}
			});
		} catch (DatabaseException e) {
			Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "getName failed for file resource " + fileResource, e));
			return e.getMessage();
		}
	}
	
	@Override
	public String getParent() {
		return null;
	}
	
	@Override
	public File getParentFile() {
		return null;
	}
	
	@Override
	public String getPath() {
		return null;
	}
	
	@Override
	public long getTotalSpace() {
		return 0;
	}
	
	@Override
	public long getUsableSpace() {
		return 0;
	}
	
	@Override
	public boolean isAbsolute() {
		return false;
	}
	
	@Override
	public boolean isDirectory() {
		return false;
	}
	
	@Override
	public boolean isFile() {
		return true;
	}
	
	@Override
	public int hashCode() {
		return fileResource.hashCode();
	}
	
	@Override
	public boolean isHidden() {
		return false;
	}
	
	@Override
	public long lastModified() {
		try {
			return Simantics.getSession().syncRequest(new Read<Long>() {
				@Override
				public Long perform(ReadGraph graph) throws DatabaseException {
					GraphFileResource gf = GraphFileResource.getInstance(graph);
					return graph.getRelatedValue(fileResource, gf.LastModified);
				}
			});
		} catch (DatabaseException e) {
			return 0;
		}
	}
	
	@Override
	public long length() {
		try {
			return getResourceData().length;
		} catch (DatabaseException e) {
			return 0;
		}
	}
	
	@Override
	public boolean mkdir() {
		return false;
	}
	
	@Override
	public boolean mkdirs() {
		return false;
	}
	
	@Override
	public boolean renameTo(File dest) {
		return false;
	}
	
	@Override
	public boolean setReadable(boolean readable) {
		return false;
	}
	
	@Override
	public boolean setReadable(boolean readable, boolean ownerOnly) {
		return false;
	}
	
	@Override
	public boolean setWritable(boolean writable) {
		return false;
	}
	
	@Override
	public boolean setWritable(boolean writable, boolean ownerOnly) {
		return false;
	}
	
	@Override
	public boolean setExecutable(boolean executable) {
		return false;
	}
	
	@Override
	public boolean setExecutable(boolean executable, boolean ownerOnly) {
		return false;
	}
	
	@Override
	public boolean setLastModified(long time) {
		return false;
	}
	
	@Override
	public String[] list() {
		return null;
	}
	
	@Override
	public String[] list(FilenameFilter filter) {
		return null;
	}
	
	@Override
	public File[] listFiles() {
		return null;
	}
	
	@Override
	public File[] listFiles(FileFilter filter) {
		return null;
	}
	
	@Override
	public File[] listFiles(FilenameFilter filter) {
		return null;
	}
	
	@Override
	public boolean setReadOnly() {
		return false;
	}
	
	@Override
	public String toString() {
		return getName();
	}
	
	@Override
	public URL toURL() throws MalformedURLException {
		return null;
	}
	
	@Override
	public URI toURI() {
		return null;
	}
	
	

}
