/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.tests;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.graph.tests._RVI._RVIPart;
import org.simantics.graph.tests._RVI._ResourceRVIPart;
import org.simantics.graph.tests._RVI._Role;
import org.simantics.graph.tests._RVI._StringRVIPart;
import org.simantics.graph.utils.TGResourceUtil;

public class TestTGResourceUtil {
	
	
	public @Test void test() throws Exception {
		
		_ResourceRVIPart part1 = new _ResourceRVIPart();
		part1.resource = 5;
		part1.role = _Role.CHILD;
		
		_StringRVIPart part2 = new _StringRVIPart();
		part2.string = "Value";
		part2.role = _Role.PROPERTY;
		
		_RVI rvi = new _RVI();
		rvi.parts = new _RVIPart[] { part1, part2 };
		rvi.variant = 3L;
		
		Binding b1 = Bindings.getBinding( _RVI.class );
		RecordBinding b2 = Bindings.getBinding( _ResourceRVIPart.class );
		b2.componentBindings[1].type().metadata.put("resource", "true");
		
		TGResourceUtil util = new TGResourceUtil();
		util.addType( b1.type() );
		
		List<Long> resources = new ArrayList<Long>();
		util.findResources(b1, rvi, resources);
		for (Long l : resources) System.out.println("Found resource: "+l);
		
		// adapt resources
		TGResourceUtil.LongAdapter la = new TGResourceUtil.LongAdapter() {
			@Override
			public long adapt(long in) {
				return in;
			}
		};
		util.adaptValue(b1, rvi, la);
		
		System.out.println("rvi = "+b1.toString(rvi));		
	}
	
	

}

class _RVI {
	
	static enum _Role { CHILD, PROPERTY }	
	public _RVIPart[] parts;
	@Union({_ResourceRVIPart.class, _StringRVIPart.class})
	interface _RVIPart {}
	static class _ResourceRVIPart implements _RVIPart {
		public _Role role;
		public long resource;
	}
	static class _StringRVIPart implements _RVIPart {
		public _Role role;
		public String string;
	}	
	public Object variant;

}