/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.procedures;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.store.PreValueStore;
import org.simantics.graph.query.IDataTypeQuery;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.StatementStore;
import org.simantics.graph.store.ValueStore;

public class ConvertPreValues
implements Runnable {
    IGraph cg;
    GraphStore store;
    Collection<Problem> problems;

    public ConvertPreValues(IGraph cg, GraphStore store, Collection<Problem> problems) {
        this.cg = cg;
        this.store = store;
        this.problems = problems;
    }

    @Override
    public void run() {
        PreValueStore preValues = (PreValueStore)this.store.getStore(PreValueStore.class);
        preValues.convertPreValues(this.store.values, new IDataTypeQuery(){
            Paths paths;
            StatementStore statements;
            ValueStore values;
            int HasDatatype;
            int InstanceOf;
            TIntObjectHashMap<Binding> typeBindingCache;
            {
                this.paths = ConvertPreValues.this.cg.getPaths();
                this.statements = ConvertPreValues.this.store.statements;
                this.values = ConvertPreValues.this.store.values;
                this.HasDatatype = ConvertPreValues.this.store.identities.createPathToId(this.paths.HasDatatype);
                this.InstanceOf = ConvertPreValues.this.store.identities.createPathToId(this.paths.InstanceOf);
                this.typeBindingCache = new TIntObjectHashMap();
            }

            public Binding getDataType(int id) {
                TIntArrayList objects = this.statements.getObjects(id, this.HasDatatype);
                if (objects.isEmpty()) {
                    objects = this.statements.getObjects(id, this.InstanceOf);
                    int i = 0;
                    while (i < objects.size()) {
                        int type = objects.getQuick(i);
                        Binding binding = this.getDatatypeForType(type);
                        if (binding != null) {
                            return binding;
                        }
                        ++i;
                    }
                    return null;
                }
                Datatype dt = this.values.getDatatypeValue(objects.getQuick(0));
                if (dt == null) {
                    return null;
                }
                return Bindings.getBinding((Datatype)dt);
            }

            private Binding getDatatypeForType(int type) {
                if (this.typeBindingCache.containsKey(type)) {
                    return (Binding)this.typeBindingCache.get(type);
                }
                Datatype dt = ConvertPreValues.this.cg.getAssertedDatatype(ConvertPreValues.this.store.idToRes(type));
                Binding binding = dt == null ? null : Bindings.getBinding((Datatype)dt);
                this.typeBindingCache.put(type, (Object)binding);
                return binding;
            }
        }, this.problems);
    }
}

