/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.io.Serializable;

public class TextSegment
implements Serializable {
    private static final long serialVersionUID = 1428883453597424952L;
    public static final transient TextSegment EMPTY = new TextSegment(0, 0);
    private final int start;
    private final int length;

    public static TextSegment whole(String s) {
        return new TextSegment(0, s.length());
    }

    public static TextSegment single(int pos) {
        return new TextSegment(pos, 1);
    }

    public static TextSegment before(int pos) {
        return new TextSegment(0, pos);
    }

    public TextSegment(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.start + this.length;
    }

    public int length() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean isWhole(String s) {
        if (s == null) {
            return false;
        }
        return this.start == 0 && this.length == s.length();
    }

    public boolean atStart(int pos) {
        return this.start == pos;
    }

    public boolean atEnd(int pos) {
        return this.end() == pos;
    }

    public boolean existsIn(String s) {
        int l;
        int n = l = s != null ? s.length() : 0;
        if (this.start > l) {
            return false;
        }
        int end = this.start + this.length;
        return end <= l;
    }

    public String removeFrom(String s) {
        if (!this.existsIn(s)) {
            throw new IllegalArgumentException("segment " + this + " is out of bounds in string '" + s + "'");
        }
        if (this.length == 0) {
            return s;
        }
        if (this.start == 0) {
            return s.substring(this.length);
        }
        return String.valueOf(s.substring(0, this.start)) + s.substring(this.start + this.length);
    }

    public String before(String s) {
        if (this.start == 0) {
            return "";
        }
        return s.substring(0, this.start);
    }

    public String after(String s) {
        if (this.end() == s.length()) {
            return "";
        }
        return s.substring(this.start, this.start + this.length);
    }

    public String of(String s) {
        return s.substring(this.start, this.start + this.length);
    }

    public TextSegment beforeStart() {
        if (this.start == 0) {
            return EMPTY;
        }
        return new TextSegment(0, this.start);
    }

    public TextSegment afterEnd(String s) {
        int l = s.length();
        int end = this.end();
        if (end > l) {
            throw new IllegalArgumentException("end " + end + " is beyond string '" + s + "'");
        }
        if (end == l) {
            return EMPTY;
        }
        return new TextSegment(end, l - end);
    }

    public TextSegment prepend(int count) {
        if (count == 0) {
            return this;
        }
        int newStart = this.start - count;
        if (newStart < 0) {
            throw new IllegalArgumentException("prepending " + this + " by " + count + " procudes invalid segment start " + newStart);
        }
        int newLength = this.length + count;
        if (newLength < 0) {
            throw new IllegalArgumentException("prepending " + this + " by " + count + " produces negative length: " + newLength);
        }
        return new TextSegment(this.start - count, newLength);
    }

    public TextSegment append(int count) {
        if (count == 0) {
            return this;
        }
        int newLength = this.length + count;
        if (newLength < 0) {
            throw new IllegalArgumentException("appending by " + count + " produces negative length: " + newLength);
        }
        return new TextSegment(this.start, newLength);
    }

    public TextSegment extendToEnd(String s) {
        int l = s.length();
        int end = this.end();
        if (end > l) {
            throw new IllegalArgumentException("end " + end + " is beyond string '" + s + "'");
        }
        if (end == l) {
            return this;
        }
        return new TextSegment(this.start, l - this.start);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextSegment other = (TextSegment)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        return "[" + this.start + "," + (this.start + this.length) + "]";
    }
}

