/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.g2d.utils.GeometryUtils;

public class PathUtils {
    public static Point2D getLineTangent(double[] lineSegment, double t) {
        int degree = PathUtils.getLineDegree(lineSegment);
        double x = 0.0;
        double y = 0.0;
        if (degree == 1) {
            x = lineSegment[2] - lineSegment[0];
            y = lineSegment[3] - lineSegment[1];
        } else if (degree == 2) {
            x = 2.0 * t * (lineSegment[0] - 2.0 * lineSegment[2] + lineSegment[4]) + 2.0 * (-lineSegment[0] + lineSegment[2]);
            y = 2.0 * t * (lineSegment[1] - 2.0 * lineSegment[3] + lineSegment[5]) + 2.0 * (-lineSegment[1] + lineSegment[3]);
        } else if (degree == 3) {
            x = 3.0 * (1.0 - t) * (1.0 - t) * (lineSegment[2] - lineSegment[0]) + 3.0 * (lineSegment[4] - lineSegment[2]) * 2.0 * t * (1.0 - t) + 3.0 * (lineSegment[6] - lineSegment[4]) * t * t;
            y = 3.0 * (1.0 - t) * (1.0 - t) * (lineSegment[3] - lineSegment[1]) + 3.0 * (lineSegment[5] - lineSegment[3]) * 2.0 * t * (1.0 - t) + 3.0 * (lineSegment[7] - lineSegment[5]) * t * t;
        }
        return new Point2D.Double(x, y);
    }

    public static Point2D getLinePos(double[] lineSegment, double t) {
        assert (lineSegment != null);
        int degree = PathUtils.getLineDegree(lineSegment);
        double x = 0.0;
        double y = 0.0;
        if (degree == 1) {
            double p0x = lineSegment[0];
            double p0y = lineSegment[1];
            double p1x = lineSegment[2];
            double p1y = lineSegment[3];
            x = p0x * (1.0 - t) + t * p1x;
            y = p0y * (1.0 - t) + t * p1y;
        } else if (degree == 2) {
            double p0x = lineSegment[0];
            double p0y = lineSegment[1];
            double p1x = lineSegment[2];
            double p1y = lineSegment[3];
            double p2x = lineSegment[4];
            double p2y = lineSegment[5];
            double c2x = p0x - 2.0 * p1x + p2x;
            double c2y = p0y - 2.0 * p1y + p2y;
            double c1x = -2.0 * p0x + 2.0 * p1x;
            double c1y = -2.0 * p0y + 2.0 * p1y;
            double c0x = p0x;
            double c0y = p0y;
            x = t * t * c2x + t * c1x + c0x;
            y = t * t * c2y + t * c1y + c0y;
        } else if (degree == 3) {
            double p0x = lineSegment[0];
            double p0y = lineSegment[1];
            double p1x = lineSegment[2];
            double p1y = lineSegment[3];
            double p2x = lineSegment[4];
            double p2y = lineSegment[5];
            double p3x = lineSegment[6];
            double p3y = lineSegment[7];
            x = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0x + 3.0 * t * (1.0 - t) * (1.0 - t) * p1x + 3.0 * t * t * (1.0 - t) * p2x + t * t * t * p3x;
            y = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0y + 3.0 * t * (1.0 - t) * (1.0 - t) * p1y + 3.0 * t * t * (1.0 - t) * p2y + t * t * t * p3y;
        }
        return new Point2D.Double(x, y);
    }

    public static double getLineLength(double[] lineSegment) {
        int degree = PathUtils.getLineDegree(lineSegment);
        if (degree == 1) {
            double dx = lineSegment[2] - lineSegment[0];
            double dy = lineSegment[3] - lineSegment[1];
            return Math.sqrt(dx * dx + dy * dy);
        }
        double result = 0.0;
        Point2D prevPos = PathUtils.getLinePos(lineSegment, 0.0);
        int i = 0;
        while (i < 10) {
            double t = (double)(i + 1) / 10.0;
            Point2D pos = PathUtils.getLinePos(lineSegment, t);
            result += pos.distance(prevPos);
            prevPos.setLocation(pos);
            ++i;
        }
        return result;
    }

    public static int getLineDegree(double[] lineSegment) {
        assert (lineSegment.length == 4 || lineSegment.length == 6 || lineSegment.length == 8);
        return (lineSegment.length - 2) / 2;
    }

    public static boolean getPathArrows(PathIterator pi, Point2D begin, Point2D beginDirection, Point2D end, Point2D endDirection) {
        Iterator<double[]> i = PathUtils.toLineIterator(pi);
        double[] first = null;
        double[] last = null;
        while (i.hasNext()) {
            double[] current = i.next();
            if (first == null) {
                first = current;
            }
            if (i.hasNext()) continue;
            last = current;
        }
        if (first == null || last == null) {
            return false;
        }
        begin.setLocation(PathUtils.getLinePos(first, 0.0));
        beginDirection.setLocation(PathUtils.getLineTangent(first, 0.0));
        end.setLocation(PathUtils.getLinePos(last, 1.0));
        Point2D endTangent = PathUtils.getLineTangent(last, 1.0);
        endDirection.setLocation(-endTangent.getX(), -endTangent.getY());
        return true;
    }

    public static Path2D interpolatePaths(PathIterator path1, PathIterator path2, double t) {
        Path2D.Double result = new Path2D.Double();
        ArrayList<double[]> l1 = new ArrayList<double[]>();
        PathUtils.toLineSegments(path1, l1);
        ArrayList<double[]> l2 = new ArrayList<double[]>();
        PathUtils.toLineSegments(path2, l2);
        l1.size();
        l2.size();
        ((Path2D)result).append(path1, false);
        return result;
    }

    public static double[] interpolateLineSegment(double[] l1, double[] l2, double t) {
        double cy;
        int d2;
        assert (t >= 0.0 && t <= 1.0);
        if (t == 0.0) {
            return Arrays.copyOf(l1, l1.length);
        }
        if (t == 1.0) {
            return Arrays.copyOf(l1, l1.length);
        }
        int d1 = PathUtils.getLineDegree(l1);
        if (d1 == (d2 = PathUtils.getLineDegree(l2))) {
            double[] result = new double[l1.length];
            int i = 0;
            while (i < l1.length) {
                result[i] = l2[i] * t + l1[i] * (1.0 - t);
                ++i;
            }
            return result;
        }
        if (d2 < d1) {
            int d_ = d1;
            d1 = d2;
            d2 = d_;
            double[] l_ = l1;
            l1 = l2;
            l2 = l_;
            t = 1.0 - t;
        }
        double[] res = new double[l2.length];
        if (d1 == 1 && d2 == 2) {
            res[0] = l1[0] * (1.0 - t) + l2[0] * t;
            res[1] = l1[1] * (1.0 - t) + l2[1] * t;
            res[4] = l1[2] * (1.0 - t) + l2[4] * t;
            res[5] = l1[3] * (1.0 - t) + l2[5] * t;
            double cx = (l1[0] + l1[2]) / 2.0;
            cy = (l1[0] + l1[2]) / 2.0;
            res[2] = cx * (1.0 - t) + l2[2] * t;
            res[3] = cy * (1.0 - t) + l2[3] * t;
        }
        if (d1 == 1 && d2 == 3) {
            res[0] = l1[0] * (1.0 - t) + l2[0] * t;
            res[1] = l1[1] * (1.0 - t) + l2[1] * t;
            res[4] = l1[2] * (1.0 - t) + l2[4] * t;
            res[5] = l1[3] * (1.0 - t) + l2[5] * t;
            double cx = (l1[0] + l1[2]) / 2.0;
            cy = (l1[0] + l1[2]) / 2.0;
            res[2] = cx * (1.0 - t) + l2[2] * t;
            res[3] = cy * (1.0 - t) + l2[3] * t;
            res[4] = cx * (1.0 - t) + l2[4] * t;
            res[5] = cy * (1.0 - t) + l2[5] * t;
        }
        if (d1 == 2 && d2 == 3) {
            res[0] = l1[0] * (1.0 - t) + l2[0] * t;
            res[1] = l1[1] * (1.0 - t) + l2[1] * t;
            res[2] = l1[2] * (1.0 - t) + l2[2] * t;
            res[3] = l1[3] * (1.0 - t) + l2[3] * t;
            res[4] = l1[2] * (1.0 - t) + l2[4] * t;
            res[5] = l1[3] * (1.0 - t) + l2[5] * t;
            res[6] = l1[4] * (1.0 - t) + l2[6] * t;
            res[7] = l1[5] * (1.0 - t) + l2[7] * t;
        }
        return res;
    }

    public static Iterator<double[]> toLineIterator(PathIterator pi) {
        return new PathIteratorToSegmentIterator(pi);
    }

    public static void toLineSegments(PathIterator pi, Collection<double[]> result) {
        Iterator<double[]> i = PathUtils.toLineIterator(pi);
        while (i.hasNext()) {
            double[] segment = i.next();
            result.add(segment);
        }
    }

    public static Point2D findIntersection(double p0x, double p0y, double dir0, double p1x, double p1y, double dir1) {
        Point2D.Double uv = new Point2D.Double();
        GeometryUtils.toUnitVector(dir0, uv);
        double v0x = ((Point2D)uv).getX();
        double v0y = ((Point2D)uv).getY();
        GeometryUtils.toUnitVector(dir1, uv);
        double v1x = ((Point2D)uv).getX();
        double v1y = ((Point2D)uv).getY();
        return PathUtils.findIntersection(p0x, p0y, v0x, v0y, p1x, p1y, v1x, v1y);
    }

    public static Point2D findIntersection(Point2D p0, Point2D v0, Point2D p1, Point2D v1) {
        double v0x = v0.getX();
        double v0y = v0.getY();
        double v1x = v1.getX();
        double v1y = v1.getY();
        double p0x = p0.getX();
        double p0y = p0.getY();
        double p1x = p1.getX();
        double p1y = p1.getY();
        return PathUtils.findIntersection(p0x, p0y, v0x, v0y, p1x, p1y, v1x, v1y);
    }

    public static Point2D findIntersection(double p0x, double p0y, double v0x, double v0y, double p1x, double p1y, double v1x, double v1y) {
        if (p0x == p1x && p0y == p1y) {
            return new Point2D.Double(p0x, p0y);
        }
        double denominator = v0y * v1x - v0x * v1y;
        if (denominator == 0.0) {
            return null;
        }
        double nominator = -v0x * p0y + v0x * p1y + v0y * p0x - v0y * p1x;
        double r = nominator / denominator;
        if (r < 0.0) {
            return null;
        }
        double x = p1x + r * v1x;
        double y = p1y + r * v1y;
        return new Point2D.Double(x, y);
    }

    public static int findNearestPoints(Point2D p0, Point2D v0, Point2D p1, Point2D v1, Point2D cp1, Point2D cp2) {
        return PathUtils.findNearestPoints(p0.getX(), p0.getY(), v0.getX(), v0.getY(), p1.getX(), p1.getY(), v1.getX(), v1.getY(), cp1, cp2);
    }

    public static int findNearestPoints(double p0x, double p0y, double v0x, double v0y, double p1x, double p1y, double v1x, double v1y, Point2D cp1, Point2D cp2) {
        int result = 0;
        double r = -(v1x * (p1x - p0x) + v1y * (p1y - p0y)) / (v1x * v1x + v1y * v1y);
        double t = -(v0x * (p0x - p1x) + v0y * (p0y - p1y)) / (v0x * v0x + v0y * v0y);
        if (t > 0.0) {
            cp1.setLocation(p0x + v0x * t, p0y + v0y * t);
            result |= 1;
        }
        if (r > 0.0) {
            cp2.setLocation(p1x + v1x * r, p1y + v1y * r);
            result |= 2;
        }
        return result;
    }

    public static double[] subdiv_takeLeft(double[] line, double t) {
        int degree = PathUtils.getLineDegree(line);
        double p0x = line[0];
        double p0y = line[1];
        double p1x = line[2];
        double p1y = line[3];
        double p1x_ = p0x * (1.0 - t) + p1x * t;
        double p1y_ = p0y * (1.0 - t) + p1y * t;
        if (degree == 1) {
            return new double[]{p0x, p0y, p1x_, p1y_};
        }
        double p2x = line[4];
        double p2y = line[5];
        double q0x = p0x * (1.0 - t) + p1x * t;
        double q0y = p0y * (1.0 - t) + p1y * t;
        double q1x = p1x * (1.0 - t) + p2x * t;
        double q1y = p1y * (1.0 - t) + p2y * t;
        double p2x_ = q0x * (1.0 - t) + q1x * t;
        double p2y_ = q0y * (1.0 - t) + q1y * t;
        if (degree == 2) {
            return new double[]{p0x, p0y, p1x_, p1y_, p2x_, p2y_};
        }
        double p3x = line[6];
        double p3y = line[7];
        double q2x = p2x * (1.0 - t) + p3x * t;
        double q2y = p2y * (1.0 - t) + p3y * t;
        double r0x = q0x * (1.0 - t) + q1x * t;
        double r0y = q0y * (1.0 - t) + q1y * t;
        double r1x = q1x * (1.0 - t) + q2x * t;
        double r1y = q1y * (1.0 - t) + q2y * t;
        double p3x_ = r0x * (1.0 - t) + r1x * t;
        double p3y_ = r0y * (1.0 - t) + r1y * t;
        if (degree == 3) {
            return new double[]{p0x, p0y, p1x_, p1y_, p2x_, p2y_, p3x_, p3y_};
        }
        return null;
    }

    public static double[] subdiv_takeRight(double[] line, double t) {
        int degree = PathUtils.getLineDegree(line);
        double p0x = line[0];
        double p0y = line[1];
        double p1x = line[2];
        double p1y = line[3];
        double p0x_ = p0x * (1.0 - t) + p1x * t;
        double p0y_ = p0y * (1.0 - t) + p1y * t;
        if (degree == 1) {
            return new double[]{p0x_, p0y_, p1x, p1y};
        }
        double p2x = line[4];
        double p2y = line[5];
        double q0x = p0x * (1.0 - t) + p1x * t;
        double q0y = p0y * (1.0 - t) + p1y * t;
        double q1x = p1x * (1.0 - t) + p2x * t;
        double q1y = p1y * (1.0 - t) + p2y * t;
        double p2x_ = q0x * (1.0 - t) + q1x * t;
        double p2y_ = q0y * (1.0 - t) + q1y * t;
        if (degree == 2) {
            return new double[]{p2x_, p2y_, q1x, q1y, p2x, p2y};
        }
        double p3x = line[6];
        double p3y = line[7];
        double q2x = p2x * (1.0 - t) + p3x * t;
        double q2y = p2y * (1.0 - t) + p3y * t;
        double r0x = q0x * (1.0 - t) + q1x * t;
        double r0y = q0y * (1.0 - t) + q1y * t;
        double r1x = q1x * (1.0 - t) + q2x * t;
        double r1y = q1y * (1.0 - t) + q2y * t;
        double p3x_ = r0x * (1.0 - t) + r1x * t;
        double p3y_ = r0y * (1.0 - t) + r1y * t;
        if (degree == 3) {
            return new double[]{p3x_, p3y_, r1x, r1y, q2x, q2y, p3x, p3y};
        }
        return null;
    }

    public static double[] cropLine(double[] line, double t0, double t1) {
        double[] temp = PathUtils.subdiv_takeLeft(line, t1);
        return PathUtils.subdiv_takeRight(temp, t0 / t1);
    }

    private static Point2D interpolateLine(double x0, double y0, double x1, double y1, double t) {
        double x = (x1 - x0) * t + x0;
        double y = (y1 - y0) * t + y0;
        return new Point2D.Double(x, y);
    }

    public static Path2D toPath(double[] lineSegment) {
        int degree = PathUtils.getLineDegree(lineSegment);
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(lineSegment[0], lineSegment[1]);
        if (degree == 1) {
            ((Path2D)p).lineTo(lineSegment[2], lineSegment[3]);
        }
        if (degree == 2) {
            ((Path2D)p).quadTo(lineSegment[2], lineSegment[3], lineSegment[4], lineSegment[5]);
        }
        if (degree == 3) {
            ((Path2D)p).curveTo(lineSegment[2], lineSegment[3], lineSegment[4], lineSegment[5], lineSegment[6], lineSegment[7]);
        }
        return p;
    }

    public static Path2D path(double ... pos) {
        assert (pos.length % 2 == 0 && pos.length >= 4);
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(pos[0], pos[1]);
        int i = 1;
        while (i < pos.length / 2) {
            ((Path2D)p).lineTo(pos[i * 2], pos[i * 2 + 1]);
            ++i;
        }
        return p;
    }

    public static Path2D closedPath(double ... pos) {
        Path2D p = PathUtils.path(pos);
        p.closePath();
        return p;
    }

    public static void main(String[] args) {
        double[] cubic = new double[]{0.0, 0.0, 0.0, -1.0, 3.0, -1.0, 3.0, 0.0};
        double[] cropped = PathUtils.cropLine(cubic, 0.2, 1.0);
        System.out.println(Arrays.toString(cropped));
        System.out.println(PathUtils.getLinePos(cubic, 0.5));
        System.out.println(PathUtils.getLinePos(cropped, 0.375));
        assert (PathUtils.findIntersection(0.0, 0.0, 90.0, 10.0, 1.0, 315.0) != null);
        assert (PathUtils.findIntersection(0.0, 0.0, 90.0, 1.0, 1.0, 89.0) != null);
        assert (PathUtils.findIntersection(0.0, 0.0, 90.0, 1.0, 1.0, 315.0) == null);
    }

    private static class PathIteratorToSegmentIterator
    implements Iterator<double[]> {
        final PathIterator pi;
        double[] lineTo = new double[6];
        double[] startPos = new double[2];
        double[] from = new double[2];
        int degree = 0;

        PathIteratorToSegmentIterator(PathIterator pi) {
            this.pi = pi;
            while (!pi.isDone()) {
                int type = pi.currentSegment(this.lineTo);
                pi.next();
                if (type == 0) {
                    this.startPos[0] = this.from[0] = this.lineTo[0];
                    this.startPos[1] = this.from[1] = this.lineTo[1];
                }
                if (type == 4) {
                    type = 1;
                    this.lineTo[0] = this.startPos[0];
                    this.lineTo[1] = this.startPos[1];
                }
                if (type < 1 || type > 3) continue;
                this.degree = type;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.degree > 0;
        }

        @Override
        public double[] next() {
            if (this.degree == 0) {
                return null;
            }
            double[] result = new double[this.degree * 2 + 2];
            result[0] = this.from[0];
            result[1] = this.from[1];
            result[2] = this.lineTo[0];
            result[3] = this.lineTo[1];
            if (this.degree == 2) {
                result[4] = this.lineTo[2];
                result[5] = this.lineTo[3];
            } else if (this.degree == 3) {
                result[6] = this.lineTo[4];
                result[7] = this.lineTo[5];
            }
            this.degree = 0;
            this.from[0] = this.lineTo[0];
            this.from[1] = this.lineTo[1];
            while (!this.pi.isDone()) {
                int type = this.pi.currentSegment(this.lineTo);
                this.pi.next();
                if (type == 0) {
                    this.startPos[0] = this.from[0] = this.lineTo[0];
                    this.startPos[1] = this.from[1] = this.lineTo[1];
                }
                if (type == 4) {
                    type = 1;
                    this.lineTo[0] = this.startPos[0];
                    this.lineTo[1] = this.startPos[1];
                }
                if (type < 1 || type > 3) continue;
                this.degree = type;
                break;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

