/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm2;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.g2d.routing.Constants;
import org.simantics.g2d.routing.IConnection;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.g2d.routing.algorithm2.LocalRouter;

public class Router4
implements IRouter2 {
    LocalRouter localRouter;
    static final AffineTransform IDENTITY = new AffineTransform();

    public Router4() {
        this(false);
    }

    public Router4(boolean roundCorners) {
        this.localRouter = new LocalRouter(roundCorners);
    }

    private Path2D route(double beginX, double beginY, int sDir, Rectangle2D beginObstacle, double endX, double endY, int tDir, Rectangle2D endObstacle) {
        this.localRouter.sx = beginX;
        this.localRouter.sy = beginY;
        if (beginObstacle == null) {
            this.localRouter.aMinX = beginX;
            this.localRouter.aMinY = beginY;
            this.localRouter.aMaxX = beginX;
            this.localRouter.aMaxY = beginY;
        } else {
            this.localRouter.aMinX = beginObstacle.getMinX();
            this.localRouter.aMinY = beginObstacle.getMinY();
            this.localRouter.aMaxX = beginObstacle.getMaxX();
            this.localRouter.aMaxY = beginObstacle.getMaxY();
        }
        this.localRouter.sourceDirection = sDir;
        this.localRouter.tx = endX;
        this.localRouter.ty = endY;
        if (endObstacle == null) {
            this.localRouter.bMinX = endX;
            this.localRouter.bMinY = endY;
            this.localRouter.bMaxX = endX;
            this.localRouter.bMaxY = endY;
        } else {
            this.localRouter.bMinX = endObstacle.getMinX();
            this.localRouter.bMinY = endObstacle.getMinY();
            this.localRouter.bMaxX = endObstacle.getMaxX();
            this.localRouter.bMaxY = endObstacle.getMaxY();
        }
        this.localRouter.targetDirection = tDir;
        this.localRouter.route();
        return this.localRouter.path;
    }

    @Override
    public void route(IConnection connection) {
        Collection<? extends Object> segments = connection.getSegments();
        if (segments.size() == 1) {
            for (Object object : segments) {
                IConnection.Connector begin = connection.getBegin(object);
                IConnection.Connector end = connection.getEnd(object);
                double bestLength = Double.POSITIVE_INFINITY;
                Path2D bestPath = null;
                int[] nArray = Constants.POSSIBLE_DIRECTIONS[begin.allowedDirections];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int sDir = nArray[n2];
                    int[] nArray2 = Constants.POSSIBLE_DIRECTIONS[end.allowedDirections];
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int tDir = nArray2[n4];
                        Path2D path = this.route(begin.x, begin.y, sDir, begin.parentObstacle, end.x, end.y, tDir, end.parentObstacle);
                        double length = Router4.pathCost(path);
                        if (length < bestLength) {
                            bestLength = length;
                            bestPath = this.localRouter.path;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (bestPath == null) continue;
                connection.setPath(object, bestPath);
            }
        } else {
            IConnection.Connector end;
            IConnection.Connector begin;
            TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
            TObjectIntHashMap rightSegments = new TObjectIntHashMap();
            TObjectIntHashMap upSegments = new TObjectIntHashMap();
            TObjectIntHashMap downSegments = new TObjectIntHashMap();
            TObjectIntHashMap horizontalCount = new TObjectIntHashMap();
            for (Object object : segments) {
                begin = connection.getBegin(object);
                end = connection.getEnd(object);
                if (begin.x < end.x) {
                    tObjectIntHashMap.adjustOrPutValue((Object)end, 1, 1);
                    rightSegments.adjustOrPutValue((Object)begin, 1, 1);
                } else {
                    tObjectIntHashMap.adjustOrPutValue((Object)begin, 1, 1);
                    rightSegments.adjustOrPutValue((Object)end, 1, 1);
                }
                if (begin.y < end.y) {
                    upSegments.adjustOrPutValue((Object)end, 1, 1);
                    downSegments.adjustOrPutValue((Object)begin, 1, 1);
                } else {
                    upSegments.adjustOrPutValue((Object)begin, 1, 1);
                    downSegments.adjustOrPutValue((Object)end, 1, 1);
                }
                if ((begin.allowedDirections & 5) != 0) {
                    horizontalCount.adjustOrPutValue((Object)end, 1, 1);
                }
                if ((begin.allowedDirections & 0xA) != 0) {
                    horizontalCount.adjustOrPutValue((Object)end, -1, -1);
                }
                if ((end.allowedDirections & 5) != 0) {
                    horizontalCount.adjustOrPutValue((Object)begin, 1, 1);
                }
                if ((end.allowedDirections & 0xA) == 0) continue;
                horizontalCount.adjustOrPutValue((Object)begin, -1, -1);
            }
            for (Object object : segments) {
                begin = connection.getBegin(object);
                end = connection.getEnd(object);
                int allowedBegin = begin.allowedDirections;
                int allowedEnd = end.allowedDirections;
                if (horizontalCount.get((Object)begin) + horizontalCount.get((Object)end) >= 0) {
                    if (begin.x < end.x) {
                        if (allowedBegin == 15) {
                            allowedBegin = rightSegments.get((Object)begin) <= 1 ? 1 : 11;
                        }
                        if (allowedEnd == 15) {
                            allowedEnd = tObjectIntHashMap.get((Object)end) <= 1 ? 4 : 14;
                        }
                    } else {
                        if (allowedBegin == 15) {
                            allowedBegin = tObjectIntHashMap.get((Object)begin) <= 1 ? 4 : 14;
                        }
                        if (allowedEnd == 15) {
                            allowedEnd = rightSegments.get((Object)end) <= 1 ? 1 : 11;
                        }
                    }
                } else if (begin.y < end.y) {
                    if (allowedBegin == 15) {
                        allowedBegin = downSegments.get((Object)begin) <= 1 ? 2 : 7;
                    }
                    if (allowedEnd == 15) {
                        allowedEnd = upSegments.get((Object)end) <= 1 ? 8 : 13;
                    }
                } else {
                    if (allowedBegin == 15) {
                        allowedBegin = upSegments.get((Object)begin) <= 1 ? 8 : 13;
                    }
                    if (allowedEnd == 15) {
                        allowedEnd = downSegments.get((Object)end) <= 1 ? 2 : 7;
                    }
                }
                double bestLength = Double.POSITIVE_INFINITY;
                Path2D bestPath = null;
                int[] nArray = Constants.POSSIBLE_DIRECTIONS[allowedBegin];
                int n = nArray.length;
                int n5 = 0;
                while (n5 < n) {
                    int sDir = nArray[n5];
                    int[] nArray2 = Constants.POSSIBLE_DIRECTIONS[allowedEnd];
                    int n2 = nArray2.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        int tDir = nArray2[n3];
                        Path2D path = this.route(begin.x, begin.y, sDir, begin.parentObstacle, end.x, end.y, tDir, end.parentObstacle);
                        double length = Router4.pathCost(path);
                        if (length < bestLength) {
                            bestLength = length;
                            bestPath = this.localRouter.path;
                        }
                        ++n3;
                    }
                    ++n5;
                }
                if (bestPath == null) continue;
                connection.setPath(object, bestPath);
            }
        }
    }

    static double pathCost(Path2D path) {
        double length = 0.0;
        PathIterator it = path.getPathIterator(IDENTITY);
        double[] temp = new double[6];
        double x = 0.0;
        double y = 0.0;
        double bendCount = 0.0;
        while (!it.isDone()) {
            bendCount += 1.0;
            if (it.currentSegment(temp) != 0) {
                length += Math.abs(x - temp[0] + y - temp[1]);
            }
            x = temp[0];
            y = temp[1];
            it.next();
        }
        return bendCount - 1.0 / length;
    }
}

