/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorHandle;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ZoomToAreaHandler
extends AbstractCanvasParticipant {
    public static final Cursor ZOOM_CURSOR = new Cursor(1);

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleZoomToArea(CommandEvent event) {
        if (Commands.ZOOM_TO_AREA.equals((Object)event.command)) {
            if (!this.getContext().containsItemByClass(ZoomToAreaMode.class)) {
                this.getContext().add(new ZoomToAreaMode());
                this.setDirty();
            }
            return true;
        }
        return false;
    }

    class ZoomToAreaMode
    extends AbstractMode {
        @DependencyReflection.Dependency
        TransformUtil util;
        @DependencyReflection.Dependency
        Selection selection;
        @DependencyReflection.Dependency
        PickContext pickContext;
        @DependencyReflection.Dependency
        KeyUtil keyUtil;
        @DependencyReflection.Dependency
        MouseUtil mouseUtil;
        @DependencyReflection.Dependency
        CanvasBoundsParticipant canvasBounds;
        public final BasicStroke STROKE;
        public static final int PAINT_PRIORITY = 30;
        Point2D startingPoint;
        Point2D currentPoint;
        IMouseCursorHandle cursor;
        protected ShapeNode node;

        public ZoomToAreaMode() {
            super(0);
            this.STROKE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);
            this.node = null;
        }

        @Override
        public void addedToContext(ICanvasContext ctx) {
            MouseUtil.MouseInfo mi;
            super.addedToContext(ctx);
            IMouseCursorContext mctx = this.getContext().getMouseCursorContext();
            if (mctx != null) {
                this.cursor = mctx.setCursor(this.getMouseId(), ZOOM_CURSOR);
            }
            if ((mi = this.mouseUtil.getMouseInfo(this.getMouseId())) != null) {
                this.currentPoint = mi.canvasPosition;
            }
        }

        @Override
        public void removedFromContext(ICanvasContext ctx) {
            if (this.cursor != null) {
                this.cursor.remove();
                this.cursor = null;
            }
            super.removedFromContext(ctx);
        }

        @EventHandlerReflection.EventHandler(priority=10)
        public boolean handleEvent(Event e) {
            if (e instanceof CommandEvent) {
                CommandEvent ce = (CommandEvent)e;
                if (ce.command.equals((Object)Commands.CANCEL)) {
                    this.setDirty();
                    this.remove();
                    return true;
                }
            } else {
                if (e instanceof MouseEvent.MouseMovedEvent) {
                    MouseEvent.MouseMovedEvent event = (MouseEvent.MouseMovedEvent)e;
                    if (event.mouseId != this.getMouseId()) {
                        return false;
                    }
                    Point2D canvasPos = this.util.controlToCanvas(event.controlPosition, null);
                    if (!ObjectUtils.objectEquals((Object)this.currentPoint, (Object)canvasPos)) {
                        this.currentPoint = canvasPos;
                        this.update(this.getBox());
                        this.setDirty();
                    }
                    return false;
                }
                if (e instanceof MouseEvent.MouseButtonEvent) {
                    MouseEvent.MouseButtonEvent event = (MouseEvent.MouseButtonEvent)e;
                    if (event.mouseId != this.getMouseId()) {
                        return false;
                    }
                    if (event.button != 1) {
                        return false;
                    }
                    if (e instanceof MouseEvent.MouseClickEvent) {
                        Point2D canvasPos;
                        this.currentPoint = canvasPos = this.util.controlToCanvas(event.controlPosition, null);
                        if (this.startingPoint == null) {
                            this.startingPoint = this.currentPoint;
                            this.setDirty();
                            return true;
                        }
                        Rectangle2D.Double area = new Rectangle2D.Double();
                        area.setFrameFromDiagonal(this.startingPoint, this.currentPoint);
                        Rectangle2D controlArea = this.canvasBounds.getControlBounds();
                        this.util.fitArea(controlArea, area, PanZoomRotateHandler.getZoomToFitMargins((IHintObservable)this.getHintStack()));
                        this.setDirty();
                        this.remove();
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }

        protected Rectangle2D getBox() {
            double temp;
            if (this.startingPoint == null) {
                return null;
            }
            Point2D p1 = this.startingPoint;
            Point2D p2 = this.currentPoint;
            double ax = p1.getX();
            double ay = p1.getY();
            double bx = p2.getX();
            double by = p2.getY();
            if (bx < ax) {
                temp = ax;
                ax = bx;
                bx = temp;
            }
            if (by < ay) {
                temp = ay;
                ay = by;
                by = temp;
            }
            return new Rectangle2D.Double(ax, ay, bx - ax, by - ay);
        }

        protected Path2D getCrossHair(Rectangle2D controlBounds) {
            Point2D controlPos = this.util.canvasToControl(this.currentPoint, null);
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(controlBounds.getMinX(), controlPos.getY());
            ((Path2D)path).lineTo(controlBounds.getMaxX(), controlPos.getY());
            ((Path2D)path).moveTo(controlPos.getX(), controlBounds.getMinY());
            ((Path2D)path).lineTo(controlPos.getX(), controlBounds.getMaxY());
            return path;
        }

        public synchronized Color getToolColor() {
            Color c = (Color)this.getHint(DiagramHints.KEY_SELECTION_FRAME_COLOR);
            if (c != null) {
                return c;
            }
            return Color.BLACK;
        }

        @SGNodeReflection.SGInit
        public void initSG(G2DParentNode parent) {
            this.node = (ShapeNode)parent.addNode("zoom to area", ShapeNode.class);
            this.node.setZIndex(30);
            this.node.setStroke((Stroke)this.STROKE);
            this.node.setScaleStroke(true);
            this.node.setColor((Paint)this.getToolColor());
            this.node.setFill(false);
        }

        void update(Shape shape) {
            if (this.node != null) {
                this.node.setShape(shape);
            }
        }

        @SGNodeReflection.SGCleanup
        public void cleanupSG() {
            if (this.node != null) {
                this.node.remove();
                this.node = null;
            }
        }
    }
}

