/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.scenegraph.SceneGraphConstants;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.MarginUtils;

public class TransformUtil
extends AbstractCanvasParticipant {
    @HintReflection.HintListener(Class=Hints.class, Field="KEY_CANVAS_TRANSFORM")
    public void transformChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.setDirty();
    }

    public Path2D toCanvasArea(Rectangle2D controlRect) {
        Point2D[] p = this.toCanvasCorners(controlRect);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(p[0].getX(), p[0].getY());
        ((Path2D)path).lineTo(p[1].getX(), p[1].getY());
        ((Path2D)path).lineTo(p[2].getX(), p[2].getY());
        ((Path2D)path).lineTo(p[3].getX(), p[3].getY());
        path.closePath();
        return path;
    }

    public Point2D[] toCanvasCorners(Rectangle2D controlRect) {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (at == null) {
            at = new AffineTransform();
        }
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        Point2D.Double p1 = new Point2D.Double(controlRect.getMinX(), controlRect.getMinY());
        Point2D.Double p2 = new Point2D.Double(controlRect.getMaxX(), controlRect.getMinY());
        Point2D.Double p3 = new Point2D.Double(controlRect.getMaxX(), controlRect.getMaxY());
        Point2D.Double p4 = new Point2D.Double(controlRect.getMinX(), controlRect.getMaxY());
        at.transform(p1, p1);
        at.transform(p2, p2);
        at.transform(p3, p3);
        at.transform(p4, p4);
        return new Point2D[]{p1, p2, p3, p4};
    }

    public Rectangle2D toCanvasRect(Rectangle2D controlRect) {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (at == null) {
            return (Rectangle2D)controlRect.clone();
        }
        Path2D path = this.toCanvasArea(controlRect);
        return path.getBounds2D();
    }

    public void controlToCanvas(Graphics2D g2d) {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (at == null) {
            return;
        }
        g2d.transform(at);
    }

    public void canvasToControl(Graphics2D g2d) {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (at == null) {
            return;
        }
        try {
            g2d.transform(at.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
    }

    public Point2D controlToCanvas(Point2D control, Point2D canvas) {
        AffineTransform at = this.getInverseTransform();
        if (canvas == null) {
            canvas = new Point2D.Double();
        }
        if (at == null) {
            canvas.setLocation(control);
            return canvas;
        }
        at.transform(control, canvas);
        return canvas;
    }

    public Point2D canvasToControl(Point2D canvas, Point2D control) {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (control == null) {
            control = new Point2D.Double();
        }
        if (at == null) {
            control.setLocation(canvas);
            return canvas;
        }
        at.transform(canvas, control);
        return control;
    }

    public Point2D canvasVectorToControlVector(Point2D canvas, Point2D control) {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (control == null) {
            control = new Point2D.Double();
        }
        if (at == null) {
            control.setLocation(canvas);
            return canvas;
        }
        double x = canvas.getX();
        double y = canvas.getY();
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m01 = at.getShearX();
        double m10 = at.getShearY();
        control.setLocation(x * m00 + y * m01, x * m10 + y * m11);
        return control;
    }

    public Point2D controlVectorToCanvasVector(Point2D control, Point2D canvas) {
        AffineTransform at = this.getInverseTransform();
        if (canvas == null) {
            canvas = new Point2D.Double();
        }
        if (at == null) {
            canvas.setLocation(control);
            return canvas;
        }
        double x = control.getX();
        double y = control.getY();
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m01 = at.getShearX();
        double m10 = at.getShearY();
        canvas.setLocation(x * m00 + y * m01, x * m10 + y * m11);
        return canvas;
    }

    public AffineTransform getTransform() {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (at == null) {
            return new AffineTransform();
        }
        return (AffineTransform)at.clone();
    }

    public AffineTransform getVectorTransform() {
        AffineTransform at = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (at == null) {
            return new AffineTransform();
        }
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m01 = at.getShearX();
        double m10 = at.getShearY();
        return new AffineTransform(m00, m10, m01, m11, 0.0, 0.0);
    }

    public AffineTransform getInverseTransform() {
        AffineTransform at = this.getTransform();
        if (at == null) {
            return null;
        }
        try {
            at = at.createInverse();
            return at;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public AffineTransform getInverseTransform(AffineTransform at) {
        if (at == null) {
            return null;
        }
        try {
            return at.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public AffineTransform getInverseVectorTransform() {
        AffineTransform at = this.getTransform();
        if (at == null) {
            return null;
        }
        try {
            at = at.createInverse();
            double m00 = at.getScaleX();
            double m11 = at.getScaleY();
            double m01 = at.getShearX();
            double m10 = at.getShearY();
            return new AffineTransform(m00, m10, m01, m11, 0.0, 0.0);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public void setTransform(AffineTransform at) {
        assert (at.getShearX() != Double.POSITIVE_INFINITY && at.getShearX() != Double.NEGATIVE_INFINITY);
        assert (at.getShearY() != Double.POSITIVE_INFINITY && at.getShearY() != Double.NEGATIVE_INFINITY);
        AffineTransform old = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (!at.equals(old)) {
            this.setHint(Hints.KEY_CANVAS_TRANSFORM, at);
            IG2DNode node = (IG2DNode)NodeUtil.findNodeById((INode)this.getContext().getSceneGraph(), (String[])SceneGraphConstants.NAVIGATION_NODE_PATH);
            if (node != null) {
                node.setTransform(at);
            }
        }
    }

    public void zoom(double scaleFactor) {
        if (scaleFactor == 1.0) {
            return;
        }
        AffineTransform diagramToControl = this.getTransform();
        diagramToControl.scale(scaleFactor, scaleFactor);
        this.setTransform(diagramToControl);
    }

    public void rotate(Point2D centerPointCanvas, double angle) {
        if (angle == 0.0) {
            return;
        }
        AffineTransform diagramToControl = this.getTransform();
        diagramToControl.rotate(-angle, centerPointCanvas.getX(), centerPointCanvas.getY());
        this.setTransform(diagramToControl);
    }

    public void restoreOrientation(Point2D centerPointCanvas) {
        AffineTransform res = new AffineTransform();
        AffineTransform at = this.getTransform();
        double m01 = at.getShearX();
        double m11 = at.getScaleY();
        double theta = Math.atan2(m01, m11);
        at.rotate(-theta, centerPointCanvas.getX(), centerPointCanvas.getY());
        res.translate(at.getTranslateX(), at.getTranslateY());
        res.scale(at.getScaleX(), at.getScaleY());
        this.setTransform(res);
    }

    public double getRotate() {
        AffineTransform at = this.getTransform();
        double m01 = at.getShearX();
        double m11 = at.getScaleY();
        return Math.atan2(m01, m11);
    }

    public void zoomAroundDiagramPoint(double scaleFactor, Point2D aroundPoint) {
        AffineTransform diagramToControl = this.getTransform();
        aroundPoint = diagramToControl.transform(aroundPoint, new Point2D.Double());
        this.zoomAroundControlPoint(scaleFactor, aroundPoint);
    }

    public void zoomAroundControlPoint(double scaleFactor, Point2D centerPoint) {
        if (scaleFactor == 1.0) {
            return;
        }
        AffineTransform diagramToControl = this.getTransform();
        try {
            Point2D pointBeforeScale = diagramToControl.inverseTransform(centerPoint, new Point2D.Double());
            diagramToControl.scale(scaleFactor, scaleFactor);
            Point2D pointAfterScale = diagramToControl.inverseTransform(centerPoint, new Point2D.Double());
            double _dx = pointAfterScale.getX() - pointBeforeScale.getX();
            double _dy = pointAfterScale.getY() - pointBeforeScale.getY();
            diagramToControl.translate(_dx, _dy);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        this.setTransform(diagramToControl);
    }

    public void translateWithCanvasCoordinates(double dx, double dy) {
        AffineTransform controlToDiagram = this.getTransform();
        controlToDiagram.translate(dx, dy);
        this.setTransform(controlToDiagram);
    }

    public void translateWithControlCoordinates(Point2D offset) {
        if (offset.getX() == 0.0 && offset.getY() == 0.0) {
            return;
        }
        AffineTransform at = this.getInverseTransform();
        offset = at.transform(offset, new Point2D.Double());
        this.translateWithCanvasCoordinates(offset.getX() - at.getTranslateX(), offset.getY() - at.getTranslateY());
    }

    public Point2D getScale(Point2D pt) {
        AffineTransform at = this.getTransform();
        return org.simantics.g2d.utils.GeometryUtils.getScaleXY(at, pt);
    }

    public void fitArea(Rectangle2D controlArea, Rectangle2D diagramArea, MarginUtils.Margins margins) {
        AffineTransform fitTx = GeometryUtils.fitArea((Rectangle2D)controlArea, (Rectangle2D)diagramArea, (MarginUtils.Margins)margins);
        this.setTransform(fitTx);
    }
}

